/**
 * @author: Sharif Zamani
 * @copyright: PersianScript
 *
 * @file
 */

/**
 * @class 
 * 
 * 
 */
var StateManager = function(guiManager, soundManager) {

    this.showGame = function() {
        if(this.currentState.getStateName() != "GameState")  {
            cleanPhysic();
	    resetRulevars();
            resetPlayer();
            reset(LEFT_PLAYER);
            playerwin = - 1;
            delete this.currentState;
            this.currentState = new GameState(this.guiManager, this.soundManager); 	
        } 
    };


    this.showMenu = function() {
        if(this.currentState.getStateName() != "MenuState") {
            delete this.currentState;
            this.currentState = new MenuState(this.guiManager, this.soundManager); 
        }
    };


    this.showWin = function(player) {
        delete this.currentState;
        this.currentState = new WinState(this.guiManager, player); 
    }    

    /**
     * @constructor
     *
     * 
     * 
     */
    this.guiManager = guiManager;
    this.soundManager = soundManager;

    this.currentState = new MenuState(this.guiManager, this.soundManager);
}

