$(document).ready(function() {
	$('.dataTable').dataTable(
	{
		 "oLanguage": {
		   "sLengthMenu": '<select >'+
			 '<option value="10">10</option>'+
			 '<option value="20">20</option>'+
			 '<option value="30">30</option>'+
			 '<option value="40">40</option>'+
			 '<option value="50">50</option>'+
			 '<option value="100">100</option>'+
			 '<option value="-1">All</option>'+
			 '</select>'
			} 
	});
	
	<!-- number and money format -->
	$(".just_number").keypress(function (e)
	{ if( e.which!=8 && e.which!=0 && (e.which < 48 || e.which > 57)) { return false; } });
	
	$(".just_money").keypress(function (e)
	{ if( e.which!=8 && e.which!=0 && e.which!=46 && (e.which < 48 || e.which > 57)) { return false; } });
<!-- /number and money format -->
});





function makeTwoChars(inp) {
		return String(inp).length < 2 ? "0" + inp : inp;
}

function initialiseInputs() {
		// Clear any old values from the inputs (that might be cached by the browser after a page reload)
		

		// Add the onchange event handler to the start date input
		datePickerController.addEvent(document.getElementById("sd"), "change", setReservationDates);
}

var initAttempts = 0;

function setReservationDates(e) {
		// Internet Explorer will not have created the datePickers yet so we poll the datePickerController Object using a setTimeout
		// until they become available (a maximum of ten times in case something has gone horribly wrong)

		try {
				var sd = datePickerController.getDatePicker("sd");
				var ed = datePickerController.getDatePicker("ed");
		} catch (err) {
				if(initAttempts++ < 10) setTimeout("setReservationDates()", 50);
				return;
		}

		// Check the value of the input is a date of the correct format
		var dt = datePickerController.dateFormat(this.value, sd.format.charAt(0) == "m");

		// If the input's value cannot be parsed as a valid date then return
		if(dt == 0) return;

		// At this stage we have a valid YYYYMMDD date

		// Grab the value set within the endDate input and parse it using the dateFormat method
		// N.B: The second parameter to the dateFormat function, if TRUE, tells the function to favour the m-d-y date format
		var edv = datePickerController.dateFormat(document.getElementById("ed").value, ed.format.charAt(0) == "m");

		// Set the low range of the second datePicker to be the date parsed from the first
		ed.setRangeLow( dt );
		
		// If theres a value already present within the end date input and it's smaller than the start date
		// then clear the end date value
		if(edv < dt) {
				document.getElementById("ed").value = "";
		}
}

function removeInputEvents() {
		// Remove the onchange event handler set within the function initialiseInputs
		datePickerController.removeEvent(document.getElementById("sd"), "change", setReservationDates);
}

datePickerController.addEvent(window, 'load', initialiseInputs);
datePickerController.addEvent(window, 'unload', removeInputEvents);