<?php
/* ############################################################ *\
 ----------------------------------------------------------------
@package	Jcow Social Networking Script.
@copyright	Copyright (C) 2009 - 2010 jcow.net.  All Rights Reserved.
@license	see http://jcow.net/license
 ----------------------------------------------------------------
\* ############################################################ */
$version = '2.5';
function get_r($arr) {
    foreach ($arr as $val) {
		GLOBAL $$val;
		if (isset( $_REQUEST[$val])) {
			if (!is_array($_REQUEST[$val])) {
				if (get_magic_quotes_gpc())
					$$val = trim($_REQUEST[$val]);
				else
					$$val = addslashes(trim($_REQUEST[$val]));
			}
			else
				$$val = $_REQUEST[$val];
		}
	}
}

function utf8_substr($str, $len = 20, $start=0) {
	$olen = strlen($str);
	for($i=0;$i<$len;$i++)
	{
		$temp_str=substr($str,0,1);
		if(ord($temp_str) > 127)
			{
			$i++;
			if($i<$len)
				{
				$new_str[]=substr($str,0,3);
				$str=substr($str,3);
				}
			}
		else
			{
			$new_str[]=substr($str,0,1);
			$str=substr($str,1);
			}
	}
	$new_str = join($new_str);
	if (strlen($new_str) < $olen) {
		$new_str = $new_str.'..';
	}
	return $new_str;
}
// get table name
function table($name) {
	GLOBAL $db_info;
	return $db_info.$name;
}

function sys_break($msg) {
	echo $msg;
	die();
}

function sys_back($msg) {
	global $alerts, $app;
	c('<div class="notice">'.$msg.'<br /><br />
	&gt;&gt; <a href="javascript:history.go(-1);void(0);">'.t('Click here to go back').'</a>
	</div>');
	set_title('Redirecting');
	nav('Redirecting');
	clear_as();
	stop_here();
}

function set_title($val) {
	global $title;
	$title  = $val;
}
function set_page_title($val) {
	global $page_title;
	$page_title  = $val;
}


function clear_as() {
	global $clear_as;
	$clear_as = 1;
}

function jcow_access($role) {
	GLOBAL $client;
	if ($role == 2) {
		if ($client['id'] != 1) {
			return false;
		}
	}
}

function do_auth($roleids, $force_uid = 0, $msg = '') {
	global $client;
	if (!allow_access($roleids, $force_uid)) {
		if ($force_uid) {
			sys_back('Sorry, you have no permission to do this.');
		}
		if ($roleids == 2 || jcow_in_array(2,$roleids)) {
			redirect('home/index/1');
		}
		if (!strlen($msg)) {
			$msg = t('Sorry, you have no permission to do this.');
		}
		if (!is_array($roleids)) {
			if (!$roleids) {
				$need_roles = '<br />No Roles was allowed';
			}
		}
		else {
			if (!$roleids[0]) {
				$need_roles = '<br />No Roles was allowed';
			}
			else {
				if (is_array($roleids)) {
					$where = ' where id in ('.implode(',',$roleids).')';
				}
				else {
					$where = ' where id='.$roleids;
				}
				$res = sql_query("select name from ".tb()."roles $where order by id");
				$need_roles = t('<br />The following roles have the permission').':<ul>';
				while ($role = sql_fetch_array($res)) {
					$need_roles .= '<li>'.h($role['name']).'</li>';
				}
				$need_roles .= '</ul>';
			}
		}
		$res = sql_query("select name from ".tb()."roles where id in(".implode(',',$client['roles']).") order by id");
		$your_roles = '<br /><br />'.t('Your current roles').':<ul>';
		while ($role = sql_fetch_array($res)) {
			$your_roles .= '<li>'.h($role['name']).'</li>';
		}
		$your_roles .= '</ul>';
		sys_back($msg.'<br /><br />'.$need_roles.$your_roles);
	}
}

function url($link,$name = 'ohno',$target='') {
	GLOBAL $ubase, $uhome;
	if ($name == '') {
		$name = $link;
	}
	if (eregi("^http",$link)) {
		$url = $link;
	}
	else {
		if (eregi("^editprofile",$link) || eregi("^admin",$link) || eregi("^login",$link) || $link == 'logout') {
			$url = $uhome.'/index.php?p='.$link;
		}
		else {
			$url = $ubase.$link;
		}
		if (!strlen($name)) {
			return $url;
		}
	}
	if ($name == 'ohno') {
		return $url;
	}
	if (eregi('delete',$link)) {
		$cfm = cfm();
	}
	if ($target)
		$target = ' target="'.$target.'"';
	return '<a href="'.$url.'"'.$target.$cfm.'>'.$name.'</a>';
}

function name2profile($name) {
	return url('u/'.$name,$name);
}
function gurl($link,$name='',$igroup = '') {
	if (!$igroup) {
		global $group;
	}
	else {
		$group = $igroup;
	}
	if ($name == '') $name = 'ohno';
	return url('group/'.$group['uri'].'/'.$link,$name);
}

function button($link, $name, $cfm = '') {
	global $ubase, $buttons;
	if (eregi('delete',$link) || $cfm) {
		$cfm = cfm($cfm);
	}
	$buttons[] = '<a class="button" href="'.$ubase.$link.'" '.$cfm.'>'.$name.'</a>';
}

function get_date($timeline, $type = 'time') {
	GLOBAL $settings, $client;
	$timeline = $timeline + $client['timezone']*3600;
	$current = time() + $client['timezone']*3600;
	$it_s = intval($current - $timeline);
	$it_m = intval($it_s/60);
	$it_h = intval($it_m/60);
	$it_d = intval($it_h/24);
	$it_y = intval($it_d/365);
	if ($type == 'date'){
		return gmdate($settings['date_format'],$timeline);
	}
	else {
		if(gmdate("j",$timeline) == gmdate("j",$current)) {
			return $settings['date_today'].', '.gmdate($settings['time_format'],$timeline);
		}
		elseif(gmdate("j",$timeline) == gmdate("j",($current-3600*24) ) ) {
			return $settings['date_yesterday'].', '.gmdate($settings['time_format'],$timeline);
		}
		return gmdate($settings['date_format'].', '.$settings['time_format'],$timeline);
	}
}

function redirect($url, $message = 0) {
	global $ubase;
	
	clear_as();
	if (!eregi("^http",$url)) {
		$url = $ubase.$url;
	}
	if (!$message) {
		ss_update();
		header("Location:$url");
		exit;
	}
	if ($message == 1 || !$message) {
		redirecting($url, t('Opration success'),'auto');
	}
	else {
		redirecting($url, $message);
	}
}



function redirecting($url, $message, $option = '') {
	global $alerts, $uhome, $auto_redirect, $config;
	$config['hide_ad'] = 1;
	if ($option == 'auto') {
		$auto_redirect = '<meta http-equiv="Refresh" content="1; url='.url($url).'" />';
		c('<div class="message"><p>'.$message.'</p>
		<img src="'.$uhome.'/files/loading.gif" /> Now redirecting to: '.url($url,$url).
			'</div>');
	}
	else {
		c('<div class="message"><p>'.$message.'</p>
		&gt;&gt; '.url($url,t('Click here to go on')).
			'</div>');
	}
	stop_here();
}

function gen_nav() {
	global $nav;
	return implode(' <span class="sub">&gt;</span> ', $nav);
}

function valid_user($val, $type = 'id') {
	global $db;
	if ($type == 'id') {
		$res = sql_query("select * from `".tb()."accounts` where id='$val' ".dbhold() );
	}
	else {
		$res = sql_query("select * from `".tb()."accounts` where username='$val' ".dbhold() );
	}
	if (sql_counts($res)) {
		return sql_fetch_array($res);
	}
	else {
		return false;
	}
}



function ip() { 
    if (isset($_SERVER)) {

        if (isset($_SERVER["HTTP_X_FORWARDED_FOR"]))
            $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
        
        elseif (isset($_SERVER["HTTP_CLIENT_IP"]))
            $ip = $_SERVER["HTTP_CLIENT_IP"];
		else
			$ip = $_SERVER["REMOTE_ADDR"];
    }

    elseif (getenv('HTTP_X_FORWARDED_FOR'))
        $ip = getenv('HTTP_X_FORWARDED_FOR');

    elseif (getenv('HTTP_CLIENT_IP'))
        $ip = getenv('HTTP_CLIENT_IP');

    else
		$ip = getenv('REMOTE_ADDR');
	return $ip;
} 



function get_rand($length, $possible = "0123456789abcdefghijklmnopqrstuvwxyz") { 
	srand((double)microtime()*1000000);
    $str = ""; 
    while(strlen($str) < $length) { 
        $str .= substr($possible, rand(0,50), 1); 
        } 
    return($str); 
} 

function t($str, $att1 = '', $att2 = '', $att3 = '') {
	global $client, $lang_options, $config;
	if (!$config['disable_language']) {
		$dbstr = addslashes($str);
		$res = sql_query("select * from `".tb()."langs` where lang_from='$dbstr' and lang='{$client['lang']}' LIMIT 1");
		if (!sql_counts($res)) {
			sql_query("insert into `".tb()."langs` (lang_from,lang_to,lang) values('$dbstr','','{$client['lang']}')");
		}
		else {
			$row = sql_fetch_array($res);
			if (strlen($row['lang_to'])) {
				$str = $row['lang_to'];
			}
			else {
				$str = $row['lang_from'];
			}
		}
	}
	return str_replace(array('{1}','{2}','{3}'),array($att1,$att2,$att3), $str);
}


// 
function save_img($src, $ext, $target = '') {
	$dir = date("Ym",time());
	$s_folder = 'uploads/userfiles/'.$dir;
	if (!is_dir($s_folder))
		mkdir($s_folder, 0777);

	// check photo
	if ($target) {
		$photo_name = $target;
	}
	else {
		$photo_name = $s_folder.'/'.date("H_i",time()).'_'.get_rand(5).'.'.$ext;
	}
	if (eregi("^http",$src)) {
		if ($get_file = @file_get_contents($src)) {
			$fp = @fopen($photo_name,"w");
			@fwrite($fp,$get_file);
			@fclose($fp);
			return $photo_name;
		}
		else {
			return false;
		}
	}
	else {
		if (copy($src, $photo_name)) {
			return $photo_name;
		}
		else {
			return false;
		}
	}
}


// ϴļ
function save_file($file, $allowed_ext = array('jpg','png','gif')) {
	$ext = strtolower($ext);
	$ext = substr($file['name'],-3,3);
	if (eregi("\.",$ext)) $ext = substr($ext,-2,2);
	if (!in_array($ext, $allowed_ext)) {
		die('Sorry, the file type is uncorrect');
	}
	$fname = date("H_i",time()).'_'.get_rand(5);
	$dir = date("Ym",time());
	$folder = 'uploads/userfiles/'.$dir;
	$uri = $folder.'/'.$fname.'.'.$ext;
	if (!is_dir($folder))
		mkdir($folder, 0777);
	if (copy($file['tmp_name'],$uri))
		return $uri;
	else {
		return false;
	}
}

function save_thumbnail($file, $width = 100, $height = 100) {
	include 'includes/resizeimage.inc.php';
	$ext = substr($file['name'],-3,3);
	$allowed_ext = array('jpg','png','gif');
	if (!in_array($ext, $allowed_ext)) {
		die('Sorry, the pic type is uncorrect');
	}
	$fname = date("H_i",time()).'_'.get_rand(5);
	$dir = date("Ym",time());
	$folder = 'uploads/userfiles/'.$dir;
	$uri = $folder.'/'.$fname.'.'.$ext;
	if (!is_dir($folder))
		mkdir($folder, 0777);
	$resizeimage = new resizeimage($file['tmp_name'], $file['type'], $folder.'/'.$fname, $width, $height, 0, 100,'white');
	return $folder.'/'.$fname.".".$resizeimage->type;
}


function cfm($msg = '') {
	if (!$msg)
		$msg = t('Are you sure to delete?');
	return ' onclick="return confirm(\''.$msg.'\');" ';
}

class PageBar
{
        public $total;        
        public $onepage;
        public $num;                        
        public $pagecount;
        public $total_page;
        public $offset;        
        public $linkhead;
		public $type_id;
		public $first = '';
		public $paras = "";
		public $prefix = "322_";

		public $next_page = 'Next';
		public $last_page = 'Prev';
		public $first_page = 'First';
		public $end_page = 'End';
    
        function PageBar($total, $onepage, $pagecount)
        {
                $this->total      = $total;
                $this->onepage    = $onepage;
                $this->total_page = ceil($total/$onepage);
                if (empty($pagecount))
                {
                        $this->pagecount = 1;
                        $this->offset         = 0;        
                }
                else
                {
                        $this->pagecount = $pagecount;
                        $this->offset    = ($pagecount-1)*$onepage;
                }

                $linkarr = explode("pagecount=", $_SERVER['QUERY_STRING']);
                $linkft  = $linkarr[0];

                if (empty($linkft))
                {
                        $this->linkhead = $_SERVER['PHP_SELF']."?".$formlink;
                }
                else
                {
                        $linkft    = (substr($linkft, -1)=="&")?$linkft:$linkft."&";
                        $this->linkhead = $_SERVER['PHP_SELF']."?".$linkft.$formlink;
                }

        }
        function offset()
        {
                return $this->offset;
        }

        function pre_page($char='')
        {
                $linkhead  = $this->linkhead;
                $pagecount = $this->pagecount;
                if (empty($char))
                {
                        $char = $this->last_page;
                }

                if ($pagecount>1)
                {
                        $pre_page = $pagecount - 1;
						if ($pre_page == 1) {
							return " <a href=\"".$this->paras."\">$char</a> ";
						}
						else {
							return " <a href=\"".$this->paras."/page".$pre_page."\">$char</a> ";
						}
                }
                else
                {
                        return '';
                }

        }

        function next_page($char='')
        {
                $linkhead   = $this->linkhead;
                $total_page = $this->total_page;
                $pagecount  = $this->pagecount;
                if (empty($char))
                {
                        $char = $this->next_page;
                }
                if ($pagecount<$total_page)
                {
                        $next_page = $pagecount + 1;
                        return " <a href=\"".$this->paras."/page".$next_page."\">$char</a> ";
                }
                else
                {
                        return '';
                }
        }

        function num_bar($num='', $color='', $left='', $right='')
        {
                $num       = (empty($num))?10:$num;
                $this->num = $num;
                $mid       = floor($num/2);
                $last      = $num - 1; 
                $pagecount = $this->pagecount;
                $totalpage = $this->total_page;
                $linkhead  = $this->linkhead;
                $color     = (empty($color))?"#ff0000":$color;
                $minpage   = (($pagecount-$mid)<1)?1:($pagecount-$mid);
                $maxpage   = $minpage + $last;
                if ($maxpage>$totalpage)
                {
                        $maxpage = $totalpage;
                        $minpage = $maxpage - $last;
                        $minpage = ($minpage<1)?1:$minpage;
                }

                for ($i=$minpage; $i<=$maxpage; $i++)
                {
                        $char = $left.$i.$right;
                        if ($i==$pagecount)
                        {
                        $linkchar = "<strong>$char</strong>";
                        }
						elseif ($i == 1) {
							$linkchar = " <a href=\"".$this->paras."\">".$char."</a> ";
						}
						else{
                        //$linkchar = " <a href='".$this->prefix.$i.".htm'>".$char."</a> ";
                        $linkchar = " <a href=\"".$this->paras."/page$i\">".$char."</a> ";
						}
                        $linkbar  = $linkbar.$linkchar;
                }

                return $linkbar;
        }

        function pre_group($char='')
        {
                $pagecount   = $this->pagecount;
				if ($pagecount > 2)
					if ($this->first) {
						$content = " <a href=\"".$this->first."\">".$this->first_page."</a> ";
					}
					else {
						$content = " <a href=\"".$this->paras."\">".$this->first_page."</a> ";
					}
				else
					$content = "";
                return "";
        }

        function next_group($char='')
        {
                $pagecount = $this->pagecount;
                $linkhead  = $this->linkhead;
                $totalpage = $this->total_page;
				if ($pagecount < ($totalpage - 1))
					$content = " <a href=\"".$this->paras."/page".$totalpage."\">".$this->end_page."</a> ";
				else
					$content = "";
                return "";
        }

    function whole_num_bar($num='', $color='')
    {
		if ($this->total <= $this->onepage) {
			return '';
		}

        $num_bar    = $this->num_bar($num, $color);
        $pre_group  = $this->pre_group();
        $pre_page   = $this->pre_page();
        $next_page  = $this->next_page();
        $next_group = $this->next_group();

            $pagebar =  $pre_group.$pre_page.$num_bar.$next_page.$next_group;
			if ($pagebar == '<strong>1</strong>')
				return "";
			else
				return '<div id="pager">'.$pagebar.'</div>';
    }

}

function hide_menubar() {
	global $config;
	$config['hide_menubar'] = 1;
}

function nav($foo) {
	global $nav;
	$nav[] = $foo;
}

function msg_unread() {
	global $client;
	if ($client['id']) {
		$res = sql_query("select count(*) as num from `".tb()."messages` where to_id='{$client['id']}' and from_id>0 and !hasread");
		$row = sql_fetch_array($res);
		$num = $row['num'];
		if ($num) {
			return '<span> ('.$num.')</span>';
		}
		else {
			return false;
		}
	}
	else {
		return false;
	}
}

function note_unread() {
	global $client;
	if ($client['id']) {
		$res = sql_query("select count(*) as num from `".tb()."messages` where to_id='{$client['id']}' and from_id=0 and !hasread");
		$row = sql_fetch_array($res);
		$num = $row['num'];
		if ($num) {
			return '<span> ('.$num.')</span>';
		}
		else {
			return false;
		}
	}
	else {
		return false;
	}
}

function send_note($id, $msg) {
	global $client;
	if ($client['id'] == $id)
		return false;
	$note['message'] = $msg;
	$note['created'] = time();
	$note['to_id'] = $id;
	sql_insert($note,tb().'messages');
}

function set_text($key, $value) {
	$res = sql_query("select * from `".tb()."texts` where tkey='$key'");
	if (sql_counts($res)) {
		sql_query("update `".tb()."texts` SET tvalue='$value' WHERE tkey='$key'");
	}
	else {
		sql_query("insert into `".tb()."texts` (tkey,tvalue) values('$key','$value')");
	}
}

function get_text($key) {
	$res = sql_query("select * from `".tb()."texts` where tkey='$key' ");
	$row = sql_fetch_array($res);
	return $row['tvalue'];
}
function avatar($row, $type = 'small') {
	global $uhome, $ubase;
	if ($row['uid']) {
		$row['id'] = $row['uid'];
	}
	if (!$row['avatar']) {
		$row['avatar'] = 'undefined.jpg';
	}
	
	if ($type == 'small') {
		$row['avatar'] = 's_'.$row['avatar'];
	}
	
	if (is_numeric($type)) {
		$row['avatar'] = 's_'.$row['avatar'];
		$csize = ' width="'.$type.'" height="'.$type.'" ';
	}
	return '<a href="'.$ubase.'u/'.$row['username'].'">
	<img '.$csize.' src="'.$uhome.'/uploads/avatars/'.$row['avatar'].'" class="avatar" /></a>';
}

function tpl_bottom() {
	global $blocks, $branding_removal;
	if (!$branding_removal) {
		$blocks['brand'] = ' '; 
	}
	return $blocks['bottom'].$blocks['brand'];
}

function frd_request() {
	global $client;
	if (!$client['id']) {
		return false;
	}
	$res = sql_query("select count(*) as num from `".tb()."friend_reqs` where fid='{$client['id']}'");
	$row = sql_fetch_array($res);
	if (!$row['num']) {
		return false;
	}
	return url('friends/requests',t('Friends').'<span> ('.$row['num'].')</span>');
}

function ubase() {
	global $ubase;
	return $ubase;
}
function uhome() {
	global $uhome;
	return $uhome;
}
function theme_folder() {
	global $theme_folder;
	return $theme_folder;
}

function get_friends($uid = 0) {
	global $client;
	if (!$uid)
		$uid = $client['id'];
	if (!$uid)
		return false;
	$res = sql_query("select fid from `".tb()."friends` where uid='$uid' LIMIT 10");
	while ($row = sql_fetch_array($res)) {
		$ids[] = $row['fid'];
	}
	return $ids;
}

// active sidebars
function ass($arr, $status = '') {
	global $ass;
	if ($status == 'highlight') {
		$arr['highlight'] = 1;
	}
	$ass[] = $arr;
}

function sys_notice($notice) {
	global $notices;
	$notices[] = $notice;
}

function jcow_mail($to,$subject,$message,$reply = '') {
	if (!$reply)
		$reply = get_gvar('site_name').'<noreply@'.$_SERVER['HTTP_HOST'].'>';
	$headers = "From: $reply\r\n" .
			"Message-ID: <".time()."-".$reply.">\r\n".
			'X-Mailer: PHP/' . phpversion() . "\r\n" .
			"MIME-Version: 1.0\r\n" .
			"Content-Type: text/html; charset=utf-8 \r\n" .
			"Content-Transfer-Encoding: 8bit\r\n\r\n";
	// Send
	$message = str_replace("\r\n",'<br />',$message);
	$mail_sent = @mail($to, $subject, $message, $headers);
	return $mail_sent;
}

function get_gvar($key) {
	global $gvars;
	return $gvars[$key];
}

function set_gvar($key, $value = '') {
	global $gvars;
	if ($value == '') {
		sql_query("delete from `".tb()."gvars` WHERE gkey='$key'");
	}
	else {
		if (!isset($gvars[$key])) {
			sql_query("insert into `".tb()."gvars` (gkey,gvalue) values ('$key', '$value')");
		}
		else {
			sql_query("update `".tb()."gvars` set gvalue='$value' where gkey='$key'");
		}
	}
}

function set_tmp($key, $value = 'deleteit', $live = 1) {
	if ($value == 'deleteit') {
		sql_query("delete from `".tb()."tmp` where tkey='$key'");
	}
	else {
		$res = sql_query("select tkey from ".tb()."tmp where tkey='$key'  limit 1");
		if (sql_counts($res)) {
			sql_query("update ".tb()."tmp set tcontent='$value' where tkey='$key'");
		}
		else {
			sql_query("insert into `".tb()."tmp` (tkey,tcontent) values('$key','$value')");
		}
	}
}
function get_tmp($key, $keep = 1) {
	$res = sql_query("select * from `".tb()."tmp` where tkey='$key'");
	$row = sql_fetch_array($res);
	if (!$keep) {
		sql_query("delete from `".tb()."tmp` where tkey='$key'");
	}
	return $row['tcontent'];
}


function set_cache($key, $value = '', $live = 1) {
	$expired = time() + 3600*$live;
	$res = sql_query("select content from `".tb()."cache` where ckey='$key'");
	if (!sql_counts($res)) {
		sql_query("insert into ".tb()."cache (ckey,content,expired) values('$key','".addslashes($value)."',$expired)");
	}
	else {
		sql_query("update ".tb()."cache set content='".addslashes($value)."',expired=$expired where ckey='$key'");
	}
}
function read_cache($key) {
	$res = sql_query("select content from `".tb()."cache` where ckey='$key' and expired>".time());
	if (!sql_counts($res))
		return false;
	else {
		$row = sql_fetch_array($res);
		return $row['content'];
	}
}


function convert_blocks($content) {
	global $client;
	if ($client['id']) {
		$content = preg_replace("({guest}(.+){\/guest})",'',$content);
		$content = str_replace('{member}','',$content);
		$content = str_replace('{/member}','',$content);
	}
	else {
		$content = preg_replace("({member}(.+){\/member})",'',$content);
		$content = str_replace('{guest}','',$content);
		$content = str_replace('{/guest}','',$content);
	}
	return $content;
}

function user_post($row, $convert = 1, $simple = 0, $hide_avatar = 0) {
	// $convert: convert HTML or not
	global $user_post_i;
	$i = $user_post_i%2 + 1;
	$user_post_i++;
	if ($row['vote'] != 0) {
		if ($row['vote'] > 0) $row['vote'] = '+'.$row['vote'];
		$row['vote_msg'] = '('.$row['vote'].')';
	}
	if ($convert) {
		$row['content'] = nl2br(decode_bb(htmlspecialchars($row['content'])));
	}
	/*
	if ($row['sid'] && $row['app']) {
		$row['content'] = url($row['app'].'/viewstory/'.$row['sid'],'#'.h($row['stitle'])).'<br />'.$row['content'];
	}
	*/
	if (!$hide_avatar) $avatar = '<td class="user_post_left" width="42" valign="top">'.avatar($row,25).'</td>';
	if ($simple) {
		return '
		<div class="user_post_'.$i.'">
			<table>
			<tr>
			'.$avatar.'
			<td class="user_post_right" valign="top">'.url('u/'.$row['username'],$row['username']).
			' '.$row['vote_msg'].' <span class="sub">'.get_date($row['created']).'</span><br />'.$row['content'].' </td>
			</tr>
			</table>
		</div>
			';
	}
	else {
		if ($row['num']) {
			$row_num = '<span class="sub">#'.$row['num'].'</span> ';
		}
		return '
		<div class="user_post_'.$i.'">
			<table width="100%">
			<tr>
			<td class="user_post_left" width="60" valign="top">'.avatar($row).'</td>
			<td class="user_post_right" valign="top"><div class="user_post_head">'.$row_num.url('u/'.$row['username'],$row['username']).
			' '.$row['vote_msg'].' <span class="sub">'.get_date($row['created']).'</span></div>'.$row['content'].'</td>
			</tr>
			</table>
		</div>
			';
	}
}


function group_post($row, $type = 'summary') {
	// $convert: convert HTML or not
	global $client, $group;
	if (!$row['uri']) $row['uri'] = $group['uri'];
	$row['rname_label'] = $row['rname'];
	$row['username_label'] = $row['username'];
	$row['message'] = nl2br(decode_bb(htmlspecialchars($row['message'])));
	if ($type == 'summary') {
		$row['message'] .= '..<br />'.url('group/'.$row['uri'].'/viewpost/'.$row['id'],'See more');
		$row['message'] .= ' | '.url('group/'.$row['uri'].'/viewpost/'.$row['id'],'Reply('.$row['replies'].')');
	}
	else {
		$row['message'] .= '<br />'.url('group/'.$row['uri'].'/viewpost/'.$row['id'],'Reply('.$row['replies'].')');
	}
	if ($row['tid']) {
		$topic = '<br />'.url('group/'.$row['uri'].'/viewtopic/'.$row['tid'],'#'.h($row['topic']) );
	}
	if ($row['rtid']) {
		$reply = url('group/'.$row['uri'].'/viewpost/'.$row['rtid'],'@'.h($row['rname_label']) );
	}
	if (!$hide_avatar) $avatar = '<td class="user_post_left" width="42" valign="top">'.avatar($row,50).'</td>';

		if ($row['num']) {
			$row_num = '<span class="sub">#'.$row['num'].'</span> ';
		}
		return '
		<div class="user_post_1">
			<table width="100%">
			<tr>
			<td class="user_post_left" width="62" valign="top">'.avatar($row).'</td>
			<td class="user_post_right" valign="top"><div class="user_post_head">'.$row_num.url('u/'.$row['username'],$row['username']).
			' '.$reply.' <span class="sub">'.get_date($row['created']).$topic.'</span></div>'
			.$row['message'].'
			</td>
			</tr>
			</table>
		</div>
			';

}

function convert_html($content) {
	global $config;
	return preg_replace(
		'/<a /i','<a rel="nofollow external" ',
		strip_tags($content,$config['allowed_html_tags'])
		);
}

function tweet($status) {
	$username = get_gvar('twitter_username');
	$password = get_gvar('twitter_password');
	if (!strlen($username) || !strlen($password)) return false;
	if ($status) {
		$tweetUrl = 'http://www.twitter.com/statuses/update.xml';
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, "$tweetUrl");
		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 2);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_POSTFIELDS, "status=$status");
		curl_setopt($curl, CURLOPT_USERPWD, "$username:$password");
		$result = curl_exec($curl);
		$resultArray = curl_getinfo($curl);
		if ($resultArray['http_code'] == 200)
			return true;
		else
			return false;
		curl_close($curl);
	}
}


function var_cache($key, $value = 'none') {
	global $var_cache_live;
	$timeline = time() - $var_cache_live;
	if ($value == 'none') { // get
		$res = sql_query("select content from `".tb()."var_cache` where created>$timeline and name='$key' ORDER BY created DESC LIMIT 1");
		if (!sql_counts($res)) {
			return false;
		}
		else {
			$row = sql_fetch_array($res);
			return $row['content'];
		}
	}
	else { // set
		sql_query("insert into `".tb()."var_cache` (name,content,created) values ('$key', '$value','".time()."')");
	}
}

function h($str) {
	return htmlspecialchars($str);
}

function tb() {
	global $table_prefix;
	return $table_prefix;
}

function p2l($p) {
	if($p >= get_gvar('user_lv8'))
		return 8;
	if($p >= get_gvar('user_lv7'))
		return 7;
	if($p >= get_gvar('user_lv6'))
		return 6;
	if($p >= get_gvar('user_lv5'))
		return 5;
	if($p >= get_gvar('user_lv4'))
		return 4;
	if($p >= get_gvar('user_lv3'))
		return 3;
	if($p >= get_gvar('user_lv2'))
		return 2;
	else
		return 1;
}

function parseurl($msg) {
        $search_array = array(
            "/([^\]]+)(http:\/\/.+)([\r\n\s]+)/isU"
		);
		$replace_array = array(
            "\\1[url]\\2[/url]\\3"
		);
		return preg_replace($search_array, $replace_array, $msg.' ');
}

function set_subtitle($title) {
	global $sub_title;
	$sub_title = $title;
}

function get_filesize($size) {
	if ($size < 1000) {
		return $size.' bytes';
	}
	elseif ($size < 1024*1024) {
		return ceil($size/1024).' kb';
	}
	elseif ($size < 1024*1024*1024) {
		return number_format($size/(1024*1024),2).' mb';
	}
	else {
		return number_format($size/(1024*1024*1024),2).' gb';
	}
}

function need_login() {
	global $client;
	if (!$client['id']) {
		redirect('home/index/1');
	}
}

function jcow_in_array($str, $arr) {
	if (!is_array($arr))
		return false;
	if (in_array($str, $arr))
		return true;
	else
		return false;
}

function show_ad($key) {
	if ($croles = get_gvar('hide_ad_roles')) {
		$croles = explode('|',$croles);
		global $client;
		foreach ($client['roles'] as $role) {
			if (in_array($role, $croles)) {
				return '';
			}
		}
	}
	return get_gvar($key);
}

function nid() {
	global $network;
	return $network['id'];
}
function network($key) {
	global $network;
	return $network[$key];
}

function label($val) {
	return '<span class="form_label">'.$val.'</span>';
}

function gender($val) {
	if ($val == 1) {
		return t('Male');
	}
	elseif ($val == 0) {
		return t('Female');
	}
	else {
		return '<i>'.t('Hidden').'</i>';
	}
}

function get_age($val, $hidden = 0) {
	if ($hidden)
		return '<i>'.t('Hidden').'</i>';
	return (date("Y",time()) - $val);
}


function show_block($as) {
	if ($as['title']) {
		$title = '<div class="block_title">
								'.$as['title'].'
								</div>';
	}
	return '
					<div class="block">
						'.$title.'
						<div class="block_content">
							'.$as['content'].'
						</div>
					</div>
					';
}

function check_menu_on($menu) {
	global $menuon;
	if (strlen($menu) && $menuon == $menu) {
		return ' class="menuon" ';
	}
	else
		return ' class="menugen" ';
}

function add_links($menu) {
	if ($name = get_gvar('cmi1_name')) {
		$menu[] = array('link'=>'<a href="'.get_gvar('cmi1_link').'"><div style="padding:3px 0 3px 23px;background:url('.uhome().'/files/appicons/links.png) 0 1px no-repeat">'.h($name).'</div></a>','name'=>h($name),'href'=>get_gvar('cmi1_link'));
	}
	if ($name = get_gvar('cmi2_name')) {
		$menu[] = array('link'=>'<a href="'.get_gvar('cmi2_link').'"><div style="padding:3px 0 3px 23px;background:url('.uhome().'/files/appicons/links.png) 0 1px no-repeat">'.h($name).'</div></a>','name'=>h($name),'href'=>get_gvar('cmi2_link'));
	}
	if ($name = get_gvar('cmi3_name')) {
		$menu[] = array('link'=>'<a href="'.get_gvar('cmi3_link').'"><div style="padding:3px 0 3px 23px;background:url('.uhome().'/files/appicons/links.png) 0 1px no-repeat">'.h($name).'</div></a>','name'=>h($name),'href'=>get_gvar('cmi3_link'));
	}
	if ($name = get_gvar('cmi4_name')) {
		$menu[] = array('link'=>'<a href="'.get_gvar('cmi4_link').'"><div style="padding:3px 0 3px 23px;background:url('.uhome().'/files/appicons/links.png) 0 1px no-repeat">'.h($name).'</div></a>','name'=>h($name),'href'=>get_gvar('cmi4_link'));
	}
	if ($name = get_gvar('cmi5_name')) {
		$menu[] = array('link'=>'<a href="'.get_gvar('cmi5_link').'"><div style="padding:3px 0 3px 23px;background:url('.uhome().'/files/appicons/links.png) 0 1px no-repeat">'.h($name).'</div></a>','name'=>h($name),'href'=>get_gvar('cmi5_link'));
	}
	return $menu;
}

function jversion() {
	global $version;
	return $version;
}
function show_rss($rss) {
	foreach ($rss['items'] as $item) {
		$items .= '
			<item>
			<title>'.$item['title'].'</title>
			<link>'.$item['link'].'</link>
			<pubDate>'.get_date($item['created']).'</pubDate>
			</item>
			';
	}

	return '<?xml version="1.0" encoding="UTF-8"?>
	<rss version="2.0"
		xmlns:content="http://purl.org/rss/1.0/modules/content/"
		xmlns:wfw="http://wellformedweb.org/CommentAPI/"
		xmlns:dc="http://purl.org/dc/elements/1.1/"
		xmlns:atom="http://www.w3.org/2005/Atom"
		xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
		xmlns:slash="http://purl.org/rss/1.0/modules/slash/"
		xmlns:georss="http://www.georss.org/georss" xmlns:geo="http://www.w3.org/2003/01/geo/wgs84_pos#" xmlns:media="http://search.yahoo.com/mrss/"
		>

	<channel>
		<title>'.$rss['title'].'</title>
		<atom:link href="'.$rss['link'].'/feed" rel="self" type="application/rss+xml" />
		<link>'.$rss['link'].'</link>
		'.$items.'
	</channel>
	</rss>
	';

}

function limit_posting($checking = 0,$ajax = 0) {
	global $client;
	
	if (allow_access(3)) {
		return true;
	}
	
	if (!$client['id'])
		return false;
	$limit = get_gvar('limit_posting_num');
	if (!$limit)
		return true;
	
	$timeline = time() - 100*3600;
	if ($client['created'] < $timeline) {
		return true;
	}
	
	$togglekey = 'memberposttoggle'.$client['id'];
	$tkey = 'memberpost'.$client['id'];
	if ($toggle = get_tmp($togglekey)) {
		if (time() > ($toggle+12*3600)) {
			return true;
		}
		else {
			if ($ajax) {
				die(t('You have exceeded you posting limit, please wait for 12 hours. By that time, your posting will be Unlimited.').'<br />');
			}
			else {
				sys_back(t('You have exceeded you posting limit, please wait for 12 hours. By that time, your posting will be Unlimited.'));
			}
		}
	}
	$current_posts = get_tmp($tkey);
	if ($current_posts >= $limit) {
		set_tmp($togglekey, time());
		set_tmp($tkey,0);
		sys_back(t('You have exceed you posting limit, please wait for 12 hours. By that time, your posting will be Unlimited.'));
	}
	if (!$current_posts) $current_posts = 0;
	$posts = $current_posts+1;
	if (!$checking) {
		set_tmp($tkey,$posts);
	}
}

function clear_report() {
	global $config;
	$config['clear_report'] = 1;
}

function enreport() {
	global $config;
	$config['enreport'] = 1;
}

function timeselector($default = 0) {
	GLOBAL $settings, $client;
	if (!$default) {
		$default = time();
	}
	$default = $default + $client['timezone']*3600;
	$default = gmdate('g:i a',$default);
	$arr = explode(':',$default);
	$arr2 = explode(' ',$arr[1]);
	$hour = $arr[0];
	$ap =$arr2[1];
	$default = $hour.':30 '.$ap;
		
	$timearr = array('12:00 am','12:30 am','1:00 am','1:30 am','2:00 am','2:30 am','3:00 am','3:30 am','4:00 am','4:30 am','5:00 am','5:30 am','6:00 am','6:30 am','7:00 am','7:30 am','8:00 am','8:30 am','9:00 am','9:30 am','10:00 am','10:30 am','11:00 am','11:30 am','12:00 pm','12:30 pm','1:00 pm','1:30 pm','2:00 pm','2:30 pm','3:00 pm','3:30 pm','4:00 pm','4:30 pm','5:00 pm','5:30 pm','6:00 pm','6:30 pm','7:00 pm','7:30 pm','8:00 pm','8:30 pm','9:00 pm','9:30 pm','10:00 pm','10:30 pm','11:00 pm','11:30 pm');
	$output = '<select name="time">';
	foreach ($timearr as $val) {
		if ($default == $val) {
			$output .= '<option value="'.$val.'" selected>'.$val.'</option>';
		}
		else {
			$output .= '<option value="'.$val.'">'.$val.'</option>';
		}
	}
	$output .= '</select>';
	return $output;
}

function app_header($content) {
	global $app_header;
	$app_header = $content;
}


function stream_form($preset='') {
	global $config ,$client;
	if (!$client['id']) return false;
	$photo_style = $video_style = 'style="display:none"';
	if ($preset == 'photo') {
		$photo_style = '';
		$attachment_type = 'photo';
		$photo_att_button_on = ' att_button_on';
		$default_msg = 'Photo description...';
	}
	elseif ($preset == 'video') {
		$video_style = '';
		$attachment_type = 'video';
		$video_att_button_on = ' att_button_on';
		$default_msg = 'Video description...';
	}
	else {
		$status_att_button_on = ' att_button_on';
		$default_msg = 'What\'s on your mind...';
	}
	if (get_gvar('app_photos')) {
		$res = sql_query("select title,id from ".tb()."stories where uid='{$client['id']}' and app='photos' order by id DESC");
		while ($row = sql_fetch_array($res)) {
			$row['title'] = h(utf8_substr($row['title'],28));
			$my_albums[] = $row;
		}
		if (is_array($my_albums)) {
			$photo_album = '<div style="padding:2px">'.t('Upload to').': <select name="album_id">';
			foreach($my_albums as $album) {
				$photo_album .= '<option value="'.$album['id'].'">'.$album['title'].'</option>';
			}
			$photo_album .= '</select></div> <div style="padding:2px 0 2px 35px">'.t('or').' '.t('New album').': <input type="text" name="album_name" size="12" /><select name="privacy"><option value="0">'.t('Public').'</option><option value="1">'.t('Friends Only').'</option></select></div>';
		}
		else {
			$photo_album = t('Album name').': <input type="text" name="album_name" size="12" value="'.t('My album').'" /> '.t('Privacy').': <select name="privacy"><option value="0">'.t('Public').'</option><option value="1">'.t('Friends Only').'</option></select>';
		}
		$photo_button = '<a href="javascript:void();" class="att_button'.$photo_att_button_on.'" id="stream_att_photo_radio"><img src="'.uhome().'/applications/photos/icon.png" /></a> ';
	}
	if (get_gvar('app_videos')) {
		$video_button = '<a href="javascript:void();" class="att_button'.$video_att_button_on.'" id="stream_att_video_radio"><img src="'.uhome().'/applications/videos/icon.png" /></a>';
	}
	if (get_gvar('app_blogs')) {
		$blog_button = '<a href="javascript:void();" class="att_button'.$blog_att_button_on.'" id="stream_att_blog_radio"><img src="'.uhome().'/applications/blogs/icon.png" /></a>';
	}
	if (get_gvar('app_events')) {
		$event_button = '<a href="javascript:void();" class="att_button'.$event_att_button_on.'" id="stream_att_event_radio"><img src="'.uhome().'/applications/events/icon.png" /></a>';
	}
	return 
		'
		<script>
		$(document).ready( function(){
				var options = {beforeSubmit:showRequest,success:showStream};
				$("#stream_form").ajaxForm(options);
				
				function showRequest() {
					if ($("#form_message")[0].value == "" && $("#attachment").val() == "status") {
						alert("please input something..");
						return false;
					}
					$("span#spanstatus").html("<img src=\"'.uhome().'/files/loading.gif\" /> Submitting");
					$("#charsRemaining").html("");
					$("#post_form").slideToggle("slow");
				}
				function showStream(responseText, statusText)  {
					$("span#spanstatus").html("");
					if ($("#attachment").val() == "status") {
						$("#posts_head").after(responseText);
						$("#form_message").attr("value","");
						$("#form_title").attr("value","");
						$("#form_submit").attr("disabled",true);
						$("#form_submit").removeClass("att_submit_active");

						$("#apps_box").html("");
						$(".stream_atts").css("display","none");
						$(".att_button").removeClass("att_button_on");
						$("#stream_att_status_radio").addClass("att_button_on");
						$("#attachment").attr("value","status");
						$("#form_message").attr("rows",3);
						$("#form_message").show();

						$("#post_form").slideToggle("slow");
					}
					else {
						$("#apps_box").html(responseText);
						$(".stream_atts").css("display","none");
						$("#post_form").slideToggle("slow");
					}
				}

				$("#form_message").click(function() {
					if ($("#form_message").attr("rows") == 2) {
							$("#form_message").attr("value","");
							$("#form_message").attr("rows",3);
							$("#stream_att").css("display","block");
						}
				});
				$("#form_message").bind("change keyup",function() {
					$("#form_submit").removeAttr("disabled");
					$("#form_submit").addClass("att_submit_active");
				});

				$("#form_message").keyup(function() {
					if ($("#attachment").val() == "status") {
						var max = parseInt($("#form_message").attr("maxlength"));
						if($(this).val().length > max){
							$(this).val($(this).val().substr(0, $(this).attr("maxlength")));
						}
						$("#charsRemaining").html("You have <strong>" + (max - $(this).val().length) + "</strong> characters remaining");
					}
				});

				$("#stream_att_status_radio").click(function() {
					$("#apps_box").html("");
					$(".att_button").removeClass("att_button_on");
					$(this).addClass("att_button_on");
					$("#attachment").attr("value","status");
					$("#form_message").attr("rows",3);
					$("#form_message").show();
				});
				$("#stream_att_blog_radio").click(function() {
					$("#form_message").hide();
					$("span#spanstatus").html("<img src=\"'.uhome().'/files/loading.gif\" /> Loading");
					$("#apps_box").load("'.uhome().'/blogs/ajax_form", function() {
						$("span#spanstatus").html("");
						$("#form_submit").removeAttr("disabled");
						$("#form_submit").addClass("att_submit_active");
					});
					$(".att_button").removeClass("att_button_on");
					$(this).addClass("att_button_on");
					$("#attachment").attr("value","blog");
					$("#charsRemaining").html("");
				});
				$("#stream_att_photo_radio").click(function() {
					$("#form_message").hide();
					$("span#spanstatus").html("<img src=\"'.uhome().'/files/loading.gif\" /> Loading");
					$("#apps_box").load("'.uhome().'/photos/ajax_form", function() {
						$("span#spanstatus").html("");
						$("#form_submit").removeAttr("disabled");
						$("#form_submit").addClass("att_submit_active");
					});
					$(".att_button").removeClass("att_button_on");
					$(this).addClass("att_button_on");
					$("#attachment").attr("value","photo");
					$("#charsRemaining").html("");
				});
				$("#stream_att_event_radio").click(function() {
					$("#form_message").hide();
					$("span#spanstatus").html("<img src=\"'.uhome().'/files/loading.gif\" /> Loading");
					$("#apps_box").load("'.uhome().'/events/ajax_form", function() {
						$("span#spanstatus").html("");
						$("#form_submit").removeAttr("disabled");
						$("#form_submit").addClass("att_submit_active");
					});
					$(".att_button").removeClass("att_button_on");
					$(this).addClass("att_button_on");
					$("#attachment").attr("value","event");
					$("#charsRemaining").html("");
				});
				$("#stream_att_video_radio").click(function() {
					$("#form_message").hide();
					$("span#spanstatus").html("<img src=\"'.uhome().'/files/loading.gif\" /> Loading");
					$("#apps_box").load("'.uhome().'/videos/ajax_form", function() {
						$("span#spanstatus").html("");
						$("#form_submit").removeAttr("disabled");
						$("#form_submit").addClass("att_submit_active");
					});
					$(".att_button").removeClass("att_button_on");
					$(this).addClass("att_button_on");
					$("#attachment").attr("value","video");
					$("#charsRemaining").html("");
				});
				 


		});
		</script>

		<span id="spanstatus"></span>
		<div id="error_box"></div>
		<div id="post_form">
		<form id="stream_form" action="'.url('streampublish').'" method="post" enctype="multipart/form-data">
		<textarea name="message" rows="2" id="form_message" maxlength="140" class="fpost"  style="width:95%" >'.$default_msg.'</textarea>
		<div id="apps_box"></div>
		<div id="charsRemaining"></div>

		<div class="stream_atts" id="stream_att_video" '.$video_style.'>
			http://www.youtube.com/watch?v=<input type="text" size="15" name="youtubeid" />
		</div>
		<table border="0" width="95%">
		<tr>
		<td>
		<div id="stream_att" style="display:none">
			<a href="javascript:void();" class="att_button'.$status_att_button_on.'" id="stream_att_status_radio"><img src="'.uhome().'/files/appicons/status.png" /></a>
			'.$blog_button.$photo_button.$event_button.$video_button.'

		</div>
		</td>
		<td align="right">
		<input type="hidden" id="attachment" name="attachment" value="status" />
		<input type="submit" value=" '.t('Share').' " class="fbutton" id="form_submit" disabled />
		</td>
		</tr>
		</table>
		
		</form>
		</div>
		
		<div id="posts_head"></div>';
		}


function comment_form($stream_id, $flag = '') {
	global $config, $client;
	if (!$client['id']) {
		return '<div>&gt;&gt;'.url('login',t('Login to comment') ).'</div>';
	}
	if (!$flag) $flag = t('Comment');
	if (!$config['comment_headed']) {
		$comment_head =  
		'
				<script>
				$(document).ready( function(){
						$(".quick_comment").click(function() {
								$(this).next().next().css("display","block");
								$(this).next().next().find(".commentmessage").focus();
								return false;
						});
						$(".commentsubmit").click(function() {
							if ($(this).prev()[0].value != "") {
								var thiscomment = $(this).parents(".quick_comment_form");
								var cbox = thiscomment.next().next();
								var mbox = thiscomment.find(".commentmessage");
								var tbox = thiscomment.next();
								cbox.html("<img src=\"'.uhome().'/files/loading.gif\" /> Submitting");
								$.post("'.uhome().'/index.php?p=jquery/comment_publish",
								{message:mbox[0].value,target_id:tbox[0].value},
								  function(data){
									cbox.html("");
									cbox.after(data);
									mbox.attr("value","");
									},"html"
								);
								return false;
							}
						});
						$(".dolike").click(function() {
							var thiscomment = $(this).next();
							var cbox = thiscomment.next().next();
							var tbox = thiscomment.next();
							cbox.html("<img src=\"'.uhome().'/files/loading.gif\" /> Submitting");
							$.post("'.uhome().'/index.php?p=jquery/dolike",
							{target_id:tbox[0].value},
							  function(data){
								cbox.html("");
								cbox.after(data);
								},"html"
							);
							$(this).css("display","none");
							return false;
						});
				});
				</script>
				';
			$config['comment_headed'] = 1;
	}
	$res = sql_query("select * from ".tb()."liked where stream_id='$stream_id' and uid='{$client['id']}' limit 1");
	if (sql_counts($res)) {
		$likeit = '<a href="#" class="dolike">'.t('Unlike').'</a>';
	}
	else {
		$likeit = '<a href="#" class="dolike">'.t('Like').'</a>';
	}


		return $comment_head.'
		<div>
		<a href="#" class="quick_comment">+'.$flag.'</a> | '.$likeit.'
			<div class="quick_comment_form" style="display:none;">
				<table border="0"><tr><td valign="top">
				<img src="'.uhome().'/uploads/avatars/s_'.$client['avatar'].'" width="25" height="25" />
				</td><td>
				<textarea name="message" rows="2" class="fpost commentmessage""  style="width:350px;" ></textarea>
				<input type="button" value=" '.$flag.' " class="fbutton commentsubmit" />
				</td></tr>
				</table>
			</div>
			<input type="hidden" name="wall_id" value="'.$stream_id.'" />
			<div></div>
		</div>';
		}


function profile_comment_form($target_id) {
	global $config ,$client;
	if (!$client['id']) return false;
	return 
		'
		<script>
		$(document).ready( function(){
				var coptions = {beforeSubmit:showcRequest,success:showComment};
				$("#pc_form").ajaxForm(coptions);
				
				function showcRequest() {
					if ($("#pc_message")[0].value == "") {
						alert("please input something..");
						return false;
					}
					$("span#pc_status").html("<img src=\"'.uhome().'/files/loading.gif\" /> Submitting");
					$("#pc_form_box").toggle("slow");
				}
				function showComment(responseText, statusText)  { 
					$("#pc_head").after(responseText);
					$("span#pc_status").html("");
					$("#pc_message").attr("value","");
					$("#pc_submit").attr("disabled",true);
					$("#pc_form_box").toggle("slow");
				}
				$("#pc_message").click(function() {
					if ($("#pc_message").attr("rows") == 2) {
							$("#pc_message").attr("value","");
							$("#whatsbb").css("display","block");
							$("#pc_message").attr("rows",7);
						}
				});
				$("#pc_message").bind("change keyup",function() {
					$("#pc_submit").removeAttr("disabled");
					$("#pc_submit").addClass("att_submit_active");
					});

		});
		</script>

		<span id="pc_status"></span>
		<div id="pc_form_box">
		<form id="pc_form" action="'.url('jquery/profile_comment_publish').'" method="post">
		
		<textarea name="message" rows="2" id="pc_message" class="fpost"  style="width:95%" >Write Comment..</textarea>
		
		<input type="hidden" name="target_id" value="'.$target_id.'" />
		<input type="submit" value=" '.t('Comment').' " class="fbutton" id="pc_submit" disabled />
		
		</form>
		</div>
		
		<div id="pc_head"></div>';
		}

function mail_notice($type,$username,$tile,$message) {
	global $client;
	$key = 'dismail_'.$type;
	$res = sql_query("select id,email,fullname,settings from ".tb()."accounts where username='$username'");
	$user = sql_fetch_array($res);
	if (!$user['id']) return false;
	if ($client['id'] == $user['id']) return false;
	$user_settings = unserialize($user['settings']);
	if (!$user_settings[$key]) {
		@jcow_mail(
			$user['email'],
			$title,
			"Dear ".$user['fullname'].",\r\n ".$message."\r\n".url('home',get_gvar('site_name'))
			);
	}
}