<?php
/**
 * @category	Core
 * @package		JomEstate
 * @copyright (C) 2009 by Comdev - All rights reserved!
 */
defined('_JEXEC') or die('Restricted access');


// During ajax calls, the following constant might not be called
if(!defined('JPATH_COMPONENT')){
	define('JPATH_COMPONENT', dirname(__FILE__));
}


// Load necessary language file since we dont store it in the language folder
$lang =& JFactory::getLanguage();
$lang->load( 'com_jomestate', JPATH_COMPONENT_SITE );

JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_jomestate'.DS.'tables');

// Xajax, Smarty
require_once (JPATH_COMPONENT.DS.'config.php');

// Require the base controller
require_once (JPATH_COMPONENT.DS.'controller.php');
require_once (JPATH_COMPONENT_SITE.DS.'libraries'.DS.'image.php');
require_once (JPATH_COMPONENT_SITE.DS.'libraries'.DS.'common.php');

// Style
$document =& JFactory::getDocument();
$document->addScript('../components/com_jomestate/assets/jquery.js');
$document->addCustomTag( '<script type="text/javascript">jQuery.noConflict();</script>' );
$document->addCustomTag('<link rel="stylesheet" type="text/css" href="components/com_jomestate/assets/css/site.css">');


// Require specific controller if requested
if($controller = JRequest::getWord('c')) { 
	$path = JPATH_COMPONENT.DS.'controllers'.DS.$controller.'.php';
	if (file_exists($path)) {
		require_once $path;
			
	} else {
		$controller = '';
	
	}
}

	$class	= 'JomestateController' . JString::ucfirst( $controller );
	

	// Test if the object really exists in the current context
	if( class_exists( $class ) )
	{
		$controller	= new $class();
	}
	else
	{
		// Throw some errors if the system is unable to locate the object's existance
		JError::raiseError( 500 , 'Invalid Controller Object. Class definition does not exists in this context.' );
	}

	
$controller->execute( JRequest::getVar( 'task' ) );
$controller->redirect();
