<?php
/**
 * @category	Core
 * @package		JomEstate
 * @copyright (C) 2009 by Comdev - All rights reserved!
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

class JomestateControllerProperties extends JController
{


	function __construct( $default = array())
	{
		
		parent::__construct( $default );
		
		$this->registerTask( 'apply', 'save' );
		$this->registerTask( 'add' , 'edit' );
		
	}

	
	
	function display()
	{

		$model	=& $this->getModel( 'properties' );
			
		$view =& $this->getView( 'properties' );
			
		$view->setModel( $model, true );
			
		switch ( $this->_task ) 
		{
					
			case 'edit': 
				$view->edit('edit.tpl.php');
			break;
				
				
			default:  
				$view->display('list.tpl.php');
			break;
			
		}	
		
	}
	
	
	/*FUNCTION: 
			delete ad and images
	*/
	function delete() {
	
		global $option,$mainframe;
		
		$db =& JFactory::getDBO();
	
		$cid = JRequest::getVar( 'cid', array(), '', 'array' );
		
		// implode multiple id's
		if(count($cid)) 
		{ 
			$cids = implode( ',', $cid ); 
		}
		
		// delete files	
		JEImage::deleteImages($cids);
	
		// delete ad
		$query = "DELETE FROM #__cd_ads WHERE id IN ( $cids )";
		$db->setQuery( $query);
		$db->query(); if ($db->getErrorNum()) { echo $db->stderr(); return false; }
		
		
		$this->setRedirect('index.php?option=com_jomestate&c=properties', JText::_('ADM_PROP_DELETED'));
	
	}
	
	
	
	
	function deleteSingleImage()
	{
	
		$column = JRequest::getVar( 'column');
				
		$db =& JFactory::getDBO();
		$cid = JRequest::getVar( 'cid');
		
		// delete file	
		JEImage::deleteSingleImage($cid,$column);
	
		$query = "UPDATE #__cd_ads SET ".$column." = '' WHERE id IN ( $cid )";
		$db->setQuery( $query);
		$db->query(); if ($db->getErrorNum()) { echo $db->stderr(); return false; }
		
		$this->setRedirect('index.php?option=com_jomestate&c=properties&task=edit&cid='.JRequest::getVar( 'cid' ).'  ', JText::_('ADM_PROP_EDIT_IMGDELETED'));
	
	}
	
	
	
	
	function save()
	{
		
		$params = &JComponentHelper::getParams( 'com_jomestate' );
		$params->merge( $itemparams );
		
		$row =& JTable::getInstance('cd_ads', 'Table');
		
		// rest of the form
		$data = JRequest::get( 'post' );
		$data['ad_features'] = serialize($data['ad_features']);
		$data['ad_description'] = JRequest::getVar('ad_description', '', 'post', 'string', JREQUEST_ALLOWRAW);
		
		$files = JRequest::getVar('img', null, 'files', 'array');
		
		// transform files array to name, type etc
		$file = JEImage::format_files_array($files);
		
		$imgUP = new JEImageUpload;
		
		$imgUP->setImagePath(JPATH_COMPONENT_SITE.DS.'uploads'.DS.'offers'.DS);
		$imgUP->setMaxImageSize($params->get('photo_upload_size'));
		$imgUP->setAllowed(array('image/pjpeg','image/gif','image/jpeg','image/JPG','image/jpg')); 
		$imgUP->setThumbWidth($params->get('photo_thumb_width'));
		
		$i = 0;
		
		$timestamp = time();
		
		// froeach file validate and upload
		foreach ($file as $single) 
		{
		
			if (!empty($single['name'])) 
			{
			
			$imgUP->setFiles($single);
			
				if (!$imgUP->checkFileType() or !$imgUP->checkFileSize()) 
				{
					JError::raiseWarning( 'ERROR_CODE', ' Please check file extension or file size: ' .$single['name'] );
					
				} else {
					
					if ($imgUP->upload($timestamp)) {

						$imgUP->createThumb();
						$imgUP->createLightBox();
							
						//	database insertion data for checked and uploade files 
						$data['img'.$i] = preg_replace("/[^a-zA-Z0-9\.]/", "", strtolower($timestamp.$single['name']) );
					
					}
				}
			
			}
		$i++;	
		}

		// bind and store
		if (!$row->bind( $data)) { return JError::raiseWarning( 500, $row->getError() ); }

		if (!$row->store()) { JError::raiseError(500, $row->getError() ); }
		
		
		switch ($this->_task)
		{
			case 'apply':
				$msg = JText::_('ADM_PROP_EDIT_APPLY');
				$link = 'index.php?option=com_jomestate&c=properties&task=edit&cid='. $row->id;
			break;
			case 'save':
			default:
				$msg = JText::_('ADM_PROP_EDIT_SAVED');
				$link = 'index.php?option=com_jomestate&c=properties';
			break;
		}

		$this->setRedirect($link,$msg);
	} 
	
} 
?>