<?php
/**
 * @category	Core
 * @package		JomEstate
 * @copyright (C) 2009 by Comdev - All rights reserved!
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

class JomestateControllerSettings extends JController
{


	function __construct( $default = array())
	{
		
		parent::__construct( $default );
		
		$this->registerTask( 'apply', 'save' );
		
	}

	

	function display()
	{
	
		$model	=& $this->getModel( 'settings' );
			
		$view =& $this->getView( 'settings' );
			
		$view->setModel( $model, true );
			
		switch ( $this->_task ) 
		{
					
			case 'edit': 
				$view->edit('edit.tpl.php');
			break;
				
				
			default:  
				$view->display('settings.tpl.php');
			break;
			
		}	
		
	}
	
	
	function saveConfig()
	{
	
		// Test if this is really a post request
		$method	= JRequest::getMethod();
		
		if( $method == 'GET' )
		{
			JError::raiseError( 500 , JText::_('Access Method not allowed') );
			return;
		}
		
		$mainframe	=& JFactory::getApplication();		

		$model	=& $this->getModel( 'Settings' );
		
		// Try to save configurations
		if( $model->save() )
		{
			
			$message	= JText::_('Configuration Updated');

			$mainframe->redirect( 'index.php?option=com_jomestate&c=settings', $message );
		
		}
		else
		{
			JError::raiseWarning( 100 , JText::_( 'Unable to save configuration into database. Please ensure that the table jos_com_jomestate_config exists' ) );
		}
	

	}
	
	
	function saveAttr($data)
	{

		$objResponse = new xajaxResponse();
			
		$row =& JTable::getInstance('cd_attr', 'Table');
		
		if (!$row->bind( $data )) {
			return JError::raiseWarning( 500, $row->getError() );
		}
		
		if (!$row->store()) {
			JError::raiseError(500, $row->getError() );
		} else {
		
			$this->setRedirect('index.php?option=com_jomestate&c=settings', JText::_('Configuration Updated'));
		}
		
		$objResponse->call('xajax_JomestateControllerSettings.fetchAttr',$data['set_id']);
		
		return $objResponse;
		
	}
	
	
	
	function fetchAttr($value) {
	
		$objResponse = new xajaxResponse();
		
		$this->tpl =& new Smarty_WebApp('settings');	
		
		$model	=& $this->getModel( 'settings' );
		
		$this->tpl->assign( 'setchange' , array(1 => JText::_('ADM_SET_ATTR_SET1'), 2 => JText::_('ADM_SET_ATTR_SET2'), 
		3 => JText::_('ADM_SET_ATTR_SET3'),4 => JText::_('ADM_SET_ATTR_SET4'),5 => JText::_('ADM_SET_ATTR_SET5') )
		);
		
		$this->tpl->assign( 'setlist' , $model->getAttr($value['set']) );
		
		$this->tpl->assign( 'setlistcurrent' , $value['set'] );
		
		$objResponse->assign('attrbox', "innerHTML",  $this->tpl->fetch('attr.tpl.php'));
	
		return $objResponse;
	
	}
	
	

	function deleteAttr($cid,$set) {
	
		$objResponse = new xajaxResponse();
		
		$db =& JFactory::getDBO();
	
		// delete ad
		$query = "DELETE FROM #__cd_attr WHERE id IN ( $cid )";
		$db->setQuery( $query);
		$db->query(); if ($db->getErrorNum()) { echo $db->stderr(); return false; }
		
		$objResponse->call('xajax_JomestateControllerSettings.fetchAttr',$set);
		
		return $objResponse;
		
	}
	
	
	
} 

// XAJAX
$card = new JomestateControllerSettings();
$xajax = new Xajax_WebApp();
$xajax->register( XAJAX_CALLABLE_OBJECT, $card );
$xajax->processRequest();
$document =& JFactory::getDocument();
$document->addCustomTag($xajax->getJavascript());
