<?php
/**
 * @category	Core
 * @package		JomEstate
 * @copyright (C) 2009 by Comdev - All rights reserved!
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.model' );


class JomestateModelSettings extends JModel
{

	/**
	 * Configuration data
	 * 
	 * @var object
	 **/	 	 	 
	var $_params;

	/**
	 * Configuration for ini path
	 * 
	 * @var string
	 **/	 	 	 
// 	var $_ini	= '';

	/**
	 * Configuration for xml path
	 * 
	 * @var string
	 **/	 	 	 
	var $_xml	= '';
	
	/**
	 * Constructor
	 */
	function __construct()
	{
		$mainframe	=& JFactory::getApplication();
		
		// Call the parents constructor
		parent::__construct();

	}
	
	/**
	 * Returns the configuration object
	 *
	 * @return object	JParameter object
	 **/	 
	function getParams()
	{
		// Test if the config is already loaded.
		if( !$this->_params )
		{
			jimport( 'joomla.filesystem.file');
			$ini	= JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_jomestate' . DS . 'config.ini';
			$data	= JFile::read($ini);
			
			// Load default configuration
			$this->_params	= new JParameter( $data );

		}
		return $this->_params;
	}
	
	/**
	 * Save the configuration to the config file
	 * 
	 * @return boolean	True on success false on failure.
	 **/
	function save()
	{
		jimport('joomla.filesystem.file');


		$registry	=& JRegistry::getInstance( 'com_jomestate' );
		$registry->loadINI( $config->params , 'com_jomestate' );
		
		$postData	= JRequest::get( 'post' , 2 );
		

		foreach( $postData as $key => $value )
		{
			if( $key != 'task' || $key != 'option' || $key != 'view' || $key != $token )
			{
				$registry->setValue( 'com_jomestate.' . $key , $value );
			}
				
		}	
		
		$file = JPATH_COMPONENT_ADMINISTRATOR.DS.'config.ini';
		
		// Get the complete INI string
		$config->params	= $registry->toString( 'INI' , 'com_jomestate' );
		
		JFile::write($file, $config->params);
		
		return true;
		
	}
	
	
	function getAttr($set_id = null)
	{
		
		$query = "SELECT * FROM #__cd_attr WHERE set_id = '".$set_id."'";
		
		$this->_db->setQuery( $query );
		
		$this->_list = $this->_db->loadAssocList(); if ($this->_db->getErrorNum()) { echo $this->_db->stderr(); return false; }
		
		return $this->_list;

	}
	
		
	
}