<?php
/**
 * @category	Core
 * @package		JomEstate
 * @copyright (C) 2009 by Comdev - All rights reserved!
 */
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.application.component.controller' );


class JomestateController extends JController
{

	function __construct( $default = array())
	{
		
		parent::__construct( $default );
		
		$this->registerTask( 'sell', 'display');
		$this->registerTask( 'rent', 'display');
		$this->registerTask( 'detailed', 'display');
		$this->registerTask( 'search', 'display');
		$this->registerTask( 'searchadv', 'display');
		$this->registerTask( 'pay', 'display');
	
		$this->session =& JFactory::getSession();
		
	}
	
	

	function display()
	{

		$model	=& $this->getModel( 'homepage' );
		
		$view =& $this->getView( 'homepage' );
		
		$view->setModel( $model, true );
		
		switch ( $this->_task ) 
		{
				
			case 'sell': 
			$view->display('home.tpl.php','sell');
			break;	
			case 'rent': 
			$view->display('home.tpl.php','rent');
			break;	
			case 'detailed': 
			$view->detailed('_detailed.tpl.php');
			break;
			case 'search': 
			$view->display('home.tpl.php','search');
			break;
			case 'searchadv': 
			$view->display('home.tpl.php','searchadv');
			break;
			case 'pay': 
			$view->pay('_pay.tpl.php');
			break;
			case 'payverify': 
			$view->payverify('_payverify.tpl.php');
			break;
			default:  
			$view->display('home.tpl.php');
			break;
		
		}
		
	
	}
	
	
	function payverify()
	{
	
		$row =& JTable::getInstance('cd_ads', 'Table');
		
		$req = 'cmd=_notify-validate';

		foreach ($_POST as $key => $value) {
			$value = urlencode(stripslashes($value));
			$req .= "&$key=$value";
		}

		// post back to PayPal system to validate
		$header .= "POST /cgi-bin/webscr HTTP/1.0\r\n";
		$header .= "Content-Type: application/x-www-form-urlencoded\r\n";
		$header .= "Content-Length: " . strlen($req) . "\r\n\r\n";
		$fp = fsockopen ('www.sandbox.paypal.com', 80, $errno, $errstr, 30);	
	
		if ($_POST['payment_status'] == 'Completed')  
		{
		
		$data['paid'] = 1;
		
		if ($_POST['myid']) {
			$data['id'] = $_POST['myid'];
		} else {
			$data['id'] = $this->session->get( 'tmpid', 'empty' );
		}
		
			if (!$row->bind( $data )) {return JError::raiseWarning( 500, $row->getError() );}
		
			if (!$row->store()) {JError::raiseError(500, $row->getError() );}
			
		$view =& $this->getView( 'homepage' );
		$view = & $this->getView('homepage');
		$view->payverify('payverify.tpl.php');
		
		} else {
		$view =& $this->getView( 'homepage' );
		$view = & $this->getView('homepage');
		$view->payverify('payverifyfail.tpl.php');
		
		}
		
		
	}
	
	
	
	/**
	FUNCTION THAT SENDS EMAIL
	**/
	function sendemail($tablica)
	{
	
		$this->tpl =& new Smarty_WebApp('homepage');	
		$objResponse = new xajaxResponse();
		
		jimport( 'joomla.mail.helper' );
		
		$tablica['body'] 	= JMailHelper::cleanBody($tablica['body']);
		$tablica['subject'] = JMailHelper::cleanSubject($tablica['subject']);
		$tablica['to'] 		= JMailHelper::cleanAddress($tablica['to']);
		
		$tablica['body'] = "From: ".$tablica['name']."<br><br><br> Buyer phone number: " .$tablica['phone']."<br><br><br> Message: ".$tablica['body'];
		
		if (!JMailHelper::isEmailAddress($tablica['from']) )
		{
			$objResponse->assign('email', "innerHTML", '<p id="error">Incorrect email address!.</p>' );
		}

		
		elseif ( JUtility::sendMail($tablica['from'], $tablica['name'], $tablica['to'],$tablica['subject'], $tablica['body'],$mode = true ) !== true )
		{
				$objResponse->assign('email', "innerHTML", '<p id="error">Error, email not send.</p>' );

		} else { 
				$objResponse->script("document.getElementById('em').reset()");
				$objResponse->assign('email', "innerHTML", '<p id="success">Thank you, email sent.</p>' );
		}
			
		return $objResponse;
		}
		
	
}

//XAJAX
$card = new JomestateController();
$xajax = new Xajax_WebApp();	
$xajax->register( XAJAX_CALLABLE_OBJECT, $card );
$xajax->processRequest();
$document =& JFactory::getDocument();
$document->addCustomTag($xajax->getJavascript());

?>