<?php
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport('joomla.application.component.view');

require_once (JPATH_COMPONENT.DS.'config.php');

class JomestateViewHomepage extends JView
{

	function __construct() 
	{
	
	parent::__construct();	
		
		$this->tpl =& new Smarty_WebApp('homepage');	
		
	}
	
	
	function display($tpl = null, $view = null)
	{ 

		global $mainframe;
		jimport('joomla.html.pagination');
		
		// classes
		$user =& JFactory::getUser();
		$model = &$this->getModel();
		
		// params
		$params = &JComponentHelper::getParams( 'com_jomestate' );
		$params->merge( $itemparams );
		
		// pagination
		$limit = JRequest::getVar('limit',$params->get( 'pages' ));
		$limitstart = JRequest::getVar('limitstart', 0);

		$this->pageNav = false;
		
		switch ($view) 
		{
		
			case 'sell': 
				$title = JText::_('JE_PROPERTIES_SALE_TITLE');
				$this->pageNav = new JPagination($model->getListTotal(0), $limitstart, $limit);
				$fetch = $model->getSell($limitstart,$limit); 
			break;
			case 'rent': 
				$title = JText::_('JE_PROPERTIES_RENT_TITLE');
				$this->pageNav = new JPagination($model->getListTotal(1), $limitstart, $limit);
				$fetch = $model->getRent($limitstart,$limit);
			break;
			case 'search': 
				$title = JText::_('JE_SEARCH_TITLE');
				$fetch = $model->getSearch();
			break;
			case 'searchadv': 
				$title = JText::_('JE_SEARCH_TITLE');
				$fetch = $model->getSearchAdv();
			break;
			default: 
				$title = JText::_('JE_LATEST_TITLE');
				$fetch = $model->getLast();
			break;
		}
		
		//set title
		$mainframe->setPageTitle( $title );
		
		$this->tpl->assign('title', $title );
		$this->tpl->assign('data',  $fetch );
		$this->tpl->assign( 'params' , $params );
		$this->tpl->assign( 'set1' , $model->getAttr('1') );
		$this->tpl->assign( 'set2' , $model->getAttr('2') );
		$this->tpl->assign( 'set3' , $model->getAttr('3') );
		$this->tpl->assign( 'set4' , $model->getAttr('4') );
		$this->tpl->assign( 'set5' , $model->getAttr('5') );
		$this->tpl->assign( 'type' , array(0 => JText::_('ADM_PROP_TYPESALE'), 1 => JText::_('ADM_PROP_TYPERENT')) );	
		$this->tpl->assign('path',JPATH_COMPONENT );
		$this->tpl->assign('pagenav', $this->pageNav);
		$this->tpl->assign('user',$user);
		$this->tpl->display($tpl);
		
	}
	

	
	
	function detailed($tpl = null)
	{ 
		
		global $mainframe;
		
		$document =& JFactory::getDocument();
		$document->addCustomTag('<script src="components/com_jomestate/assets/lightbox/js/jquery.lightbox.js" type="text/javascript"></script>');
		
		$model = &$this->getModel();
		
		//user handle
		$user =& JFactory::getUser();
		
		// params
		$params = &JComponentHelper::getParams( 'com_jomestate' );
		$params->merge( $itemparams );
		
		$this->tpl->assign( 'set1' , $model->getAttr('1') );
		$this->tpl->assign( 'set2' , $model->getAttr('2') );
		$this->tpl->assign( 'set3' , $model->getAttr('3') );
		$this->tpl->assign( 'set4' , $model->getAttr('4') );
		$this->tpl->assign( 'set5' , $model->getAttr('5') );
		$this->tpl->assign( 'type' , array(0 => JText::_('ADM_PROP_TYPESALE'), 1 => JText::_('ADM_PROP_TYPERENT')) );
		$this->tpl->assign('path',JPATH_COMPONENT );
		$this->tpl->assign('detailed',$model->getDetailed() );
		$this->tpl->assign( 'params', $params );
		$this->tpl->assign('user_fromid',$model->getUser());
		$this->tpl->assign('user',$user);
		$this->tpl->assign('mainframe',$mainframe);
		$this->tpl->display($tpl);
		
	}
	
	

	
	
	function pay($tpl = null)
	{ 
	
		/*Z panelu adm parametry*/
		$params = &JComponentHelper::getParams( 'com_jomestate' );
		$params->merge( $itemparams );
		$this->tpl->assign('account',$params->get( 'account' ));
		$this->tpl->assign('amount',$params->get( 'amount' ));
	

		//user handle
		$user =& JFactory::getUser();
		$this->tpl->assign('path',JPATH_COMPONENT );
		
		$this->tpl->assign('user',$user);
		$this->tpl->display($tpl);
		
	}
	
	
	function payverify($tpl = null)
	{ 

		//user handle
		$user =& JFactory::getUser();
		$this->tpl->assign('path',JPATH_COMPONENT );
			

		$this->tpl->assign('user',$user);
		$this->tpl->display($tpl);
		
	}
	
	
}
?>
