<?php

return [
    
    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Stripe, Mailgun, Mandrill, and others. This file provides a sane
    | default location for this type of information, allowing packages
    | to have a conventional place to find your various credentials.
    |
    */
    
    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN', null),
        'secret' => env('MAILGUN_SECRET', null),
        'guzzle' => [
            'verify' => false,
        ],
    ],
    
    'mandrill' => [
        'secret' => env('MANDRILL_SECRET', null),
        'guzzle' => [
            'verify' => false,
        ],
    ],
    
    'ses' => [
        'key' => env('SES_KEY', null),
        'secret' => env('SES_SECRET', null),
        'region' => env('SES_REGION', 'eu-west-1'),
    ],
    
    'sparkpost' => [
        'secret' => env('SPARKPOST_SECRET'),
        'guzzle' => [
            'verify' => false,
        ],
    ],
    
    'stripe' => [
        'model' => App\Larapen\Models\User::class,
        'key' => env('STRIPE_KEY'),
        'secret' => env('STRIPE_SECRET'),
    ],
    
    'paypal' => [
        'mode' => env('PAYPAL_MODE', 'sandbox'),
        'username' => env('PAYPAL_USERNAME', null),
        'password' => env('PAYPAL_PASSWORD', null),
        'signature' => env('PAYPAL_SIGNATURE', null),
    ],
    
    'facebook' => [
        'client_id' => env('FACEBOOK_CLIENT_ID', null),
        'client_secret' => env('FACEBOOK_CLIENT_SECRET', null),
        'redirect' => url('auth/facebook/callback'),
    ],
    
    'google' => [
        'client_id' => env('GOOGLE_CLIENT_ID', null),
        'client_secret' => env('GOOGLE_CLIENT_SECRET', null),
        'redirect' => url('auth/google/callback'),
    ],
    
    'twitter' => [
        'client_id' => env('TWITTER_CLIENT_ID', null),
        'client_secret' => env('TWITTER_CLIENT_SECRET', null),
        'redirect' => url('auth/twitter/callback'),
    ],
    
    'googlemaps' => [
        'key' => env('GOOGLE_MAPS_API_KEY', null), //-> for Google Map JavaScript & Embeded
    ],

];
