<?php
/**
 * LaraClassified - Geo Classified Ads CMS
 * Copyright (c) Mayeul Akpovi. All Rights Reserved
 *
 * Email: mayeul.a@larapen.com
 * Website: http://larapen.com
 *
 * LICENSE
 * -------
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the inclusion
 * of the above copyright notice. If you Purchased from Codecanyon,
 * Please read the full License from here - http://codecanyon.net/licenses/standard
 */

use Illuminate\Database\Seeder;

class CurrenciesTableSeeder extends Seeder
{
    /**
     * Insert data
     *
     * @return void
     */
    public function run()
    {
        \DB::table('currencies')->delete();
        
        \DB::table('currencies')->insert(array(
            0   => array(
                'id'              => '1',
                'code'            => 'AED',
                'name'            => 'United Arab Emirates Dirham',
                'html_entity'     => '&#1583;.&#1573;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            1   => array(
                'id'              => '2',
                'code'            => 'AFN',
                'name'            => 'Afghanistan Afghani',
                'html_entity'     => '&#65;&#102;',
                'font_arial'      => '؋',
                'font_code2000'   => '؋',
                'unicode_decimal' => '1547',
                'unicode_hex'     => '60b',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            2   => array(
                'id'              => '3',
                'code'            => 'ALL',
                'name'            => 'Albania Lek',
                'html_entity'     => '&#76;&#101;&#107;',
                'font_arial'      => 'Lek',
                'font_code2000'   => 'Lek',
                'unicode_decimal' => '76, 1',
                'unicode_hex'     => '4c, 6',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            3   => array(
                'id'              => '4',
                'code'            => 'AMD',
                'name'            => 'Armenia Dram',
                'html_entity'     => '',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            4   => array(
                'id'              => '5',
                'code'            => 'ANG',
                'name'            => 'Netherlands Antilles Guilder',
                'html_entity'     => '&#402;',
                'font_arial'      => 'ƒ',
                'font_code2000'   => 'ƒ',
                'unicode_decimal' => '402',
                'unicode_hex'     => '192',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            5   => array(
                'id'              => '6',
                'code'            => 'AOA',
                'name'            => 'Angola Kwanza',
                'html_entity'     => '&#75;&#122;',
                'font_arial'      => 'Kz',
                'font_code2000'   => 'Kz',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            6   => array(
                'id'              => '7',
                'code'            => 'ARS',
                'name'            => 'Argentina Peso',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            7   => array(
                'id'              => '8',
                'code'            => 'AUD',
                'name'            => 'Australia Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            8   => array(
                'id'              => '9',
                'code'            => 'AWG',
                'name'            => 'Aruba Guilder',
                'html_entity'     => '&#402;',
                'font_arial'      => 'ƒ',
                'font_code2000'   => 'ƒ',
                'unicode_decimal' => '402',
                'unicode_hex'     => '192',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            9   => array(
                'id'              => '10',
                'code'            => 'AZN',
                'name'            => 'Azerbaijan New Manat',
                'html_entity'     => '&#1084;&#1072;&#1085;',
                'font_arial'      => 'ман',
                'font_code2000'   => 'ман',
                'unicode_decimal' => '1084,',
                'unicode_hex'     => '43c, ',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            10  => array(
                'id'              => '11',
                'code'            => 'BAM',
                'name'            => 'Bosnia and Herzegovina Convertible Marka',
                'html_entity'     => '&#75;&#77;',
                'font_arial'      => 'KM',
                'font_code2000'   => 'KM',
                'unicode_decimal' => '75, 7',
                'unicode_hex'     => '4b, 4',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            11  => array(
                'id'              => '12',
                'code'            => 'BBD',
                'name'            => 'Barbados Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            12  => array(
                'id'              => '13',
                'code'            => 'BDT',
                'name'            => 'Bangladesh Taka',
                'html_entity'     => '&#2547;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            13  => array(
                'id'              => '14',
                'code'            => 'BGN',
                'name'            => 'Bulgaria Lev',
                'html_entity'     => '&#1083;&#1074;',
                'font_arial'      => 'лв',
                'font_code2000'   => 'лв',
                'unicode_decimal' => '1083,',
                'unicode_hex'     => '43b, ',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            14  => array(
                'id'              => '15',
                'code'            => 'BHD',
                'name'            => 'Bahrain Dinar',
                'html_entity'     => '.&#1583;.&#1576;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            15  => array(
                'id'              => '16',
                'code'            => 'BIF',
                'name'            => 'Burundi Franc',
                'html_entity'     => '&#70;&#66;&#117;',
                'font_arial'      => 'FBu',
                'font_code2000'   => 'FBu',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            16  => array(
                'id'              => '17',
                'code'            => 'BMD',
                'name'            => 'Bermuda Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            17  => array(
                'id'              => '18',
                'code'            => 'BND',
                'name'            => 'Brunei Darussalam Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            18  => array(
                'id'              => '19',
                'code'            => 'BOB',
                'name'            => 'Bolivia Boliviano',
                'html_entity'     => '&#36;&#98;',
                'font_arial'      => '$b',
                'font_code2000'   => '$b',
                'unicode_decimal' => '36, 9',
                'unicode_hex'     => '24, 6',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            19  => array(
                'id'              => '20',
                'code'            => 'BRL',
                'name'            => 'Brazil Real',
                'html_entity'     => '&#82;&#36;',
                'font_arial'      => 'R$',
                'font_code2000'   => 'R$',
                'unicode_decimal' => '82, 3',
                'unicode_hex'     => '52, 2',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            20  => array(
                'id'              => '21',
                'code'            => 'BSD',
                'name'            => 'Bahamas Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            21  => array(
                'id'              => '22',
                'code'            => 'BTN',
                'name'            => 'Bhutan Ngultrum',
                'html_entity'     => '&#78;&#117;&#46;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            22  => array(
                'id'              => '23',
                'code'            => 'BWP',
                'name'            => 'Botswana Pula',
                'html_entity'     => '&#80;',
                'font_arial'      => 'P',
                'font_code2000'   => 'P',
                'unicode_decimal' => '80',
                'unicode_hex'     => '50',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            23  => array(
                'id'              => '24',
                'code'            => 'BYR',
                'name'            => 'Belarus Ruble',
                'html_entity'     => '&#112;&#46;',
                'font_arial'      => 'p.',
                'font_code2000'   => 'p.',
                'unicode_decimal' => '112, ',
                'unicode_hex'     => '70, 2',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            24  => array(
                'id'              => '25',
                'code'            => 'BZD',
                'name'            => 'Belize Dollar',
                'html_entity'     => '&#66;&#90;&#36;',
                'font_arial'      => 'BZ$',
                'font_code2000'   => 'BZ$',
                'unicode_decimal' => '66, 9',
                'unicode_hex'     => '42, 5',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            25  => array(
                'id'              => '26',
                'code'            => 'CAD',
                'name'            => 'Canada Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            26  => array(
                'id'              => '27',
                'code'            => 'CDF',
                'name'            => 'Congo/Kinshasa Franc',
                'html_entity'     => '&#70;&#67;',
                'font_arial'      => 'Fr',
                'font_code2000'   => 'Fr',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            27  => array(
                'id'              => '28',
                'code'            => 'CHF',
                'name'            => 'Switzerland Franc',
                'html_entity'     => '&#67;&#72;&#70;',
                'font_arial'      => 'CHF',
                'font_code2000'   => 'CHF',
                'unicode_decimal' => '67, 7',
                'unicode_hex'     => '43, 4',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            28  => array(
                'id'              => '29',
                'code'            => 'CLP',
                'name'            => 'Chile Peso',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            29  => array(
                'id'              => '30',
                'code'            => 'CNY',
                'name'            => 'China Yuan Renminbi',
                'html_entity'     => '&#165;',
                'font_arial'      => '¥',
                'font_code2000'   => '¥',
                'unicode_decimal' => '165',
                'unicode_hex'     => 'a5',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            30  => array(
                'id'              => '31',
                'code'            => 'COP',
                'name'            => 'Colombia Peso',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            31  => array(
                'id'              => '32',
                'code'            => 'CRC',
                'name'            => 'Costa Rica Colon',
                'html_entity'     => '&#8353;',
                'font_arial'      => '₡',
                'font_code2000'   => '₡',
                'unicode_decimal' => '8353',
                'unicode_hex'     => '20a1',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            32  => array(
                'id'              => '33',
                'code'            => 'CUC',
                'name'            => 'Cuba Convertible Peso',
                'html_entity'     => null,
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            33  => array(
                'id'              => '34',
                'code'            => 'CUP',
                'name'            => 'Cuba Peso',
                'html_entity'     => '&#8396;',
                'font_arial'      => '₱',
                'font_code2000'   => '₱',
                'unicode_decimal' => '8369',
                'unicode_hex'     => '20b1',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            34  => array(
                'id'              => '35',
                'code'            => 'CVE',
                'name'            => 'Cape Verde Escudo',
                'html_entity'     => '&#x24;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            35  => array(
                'id'              => '36',
                'code'            => 'CZK',
                'name'            => 'Czech Republic Koruna',
                'html_entity'     => '&#75;&#269;',
                'font_arial'      => 'Kč',
                'font_code2000'   => 'Kč',
                'unicode_decimal' => '75, 2',
                'unicode_hex'     => '4b, 1',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            36  => array(
                'id'              => '37',
                'code'            => 'DJF',
                'name'            => 'Djibouti Franc',
                'html_entity'     => '&#70;&#100;&#106;',
                'font_arial'      => 'Fr',
                'font_code2000'   => 'Fr',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            37  => array(
                'id'              => '38',
                'code'            => 'DKK',
                'name'            => 'Denmark Krone',
                'html_entity'     => '&#107;&#114;',
                'font_arial'      => 'kr',
                'font_code2000'   => 'kr',
                'unicode_decimal' => '107, ',
                'unicode_hex'     => '6b, 7',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            38  => array(
                'id'              => '39',
                'code'            => 'DOP',
                'name'            => 'Dominican Republic Peso',
                'html_entity'     => '&#82;&#68;&#36;',
                'font_arial'      => 'RD$',
                'font_code2000'   => 'RD$',
                'unicode_decimal' => '82, 6',
                'unicode_hex'     => '52, 4',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            39  => array(
                'id'              => '40',
                'code'            => 'DZD',
                'name'            => 'Algeria Dinar',
                'html_entity'     => '&#1583;&#1580;',
                'font_arial'      => 'DA',
                'font_code2000'   => 'DA',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            40  => array(
                'id'              => '41',
                'code'            => 'EEK',
                'name'            => 'Estonia Kroon',
                'html_entity'     => null,
                'font_arial'      => 'kr',
                'font_code2000'   => 'kr',
                'unicode_decimal' => '107, ',
                'unicode_hex'     => '6b, 7',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            41  => array(
                'id'              => '42',
                'code'            => 'EGP',
                'name'            => 'Egypt Pound',
                'html_entity'     => '&#163;',
                'font_arial'      => '£',
                'font_code2000'   => '£',
                'unicode_decimal' => '163',
                'unicode_hex'     => 'a3',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            42  => array(
                'id'              => '43',
                'code'            => 'ERN',
                'name'            => 'Eritrea Nakfa',
                'html_entity'     => '&#x4E;&#x66;&#x6B;',
                'font_arial'      => 'Nfk',
                'font_code2000'   => 'Nfk',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            43  => array(
                'id'              => '44',
                'code'            => 'ETB',
                'name'            => 'Ethiopia Birr',
                'html_entity'     => '&#66;&#114;',
                'font_arial'      => 'Br',
                'font_code2000'   => 'Br',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            44  => array(
                'id'              => '45',
                'code'            => 'EUR',
                'name'            => 'Euro Member Countries',
                'html_entity'     => '&#8364;',
                'font_arial'      => '€',
                'font_code2000'   => '€',
                'unicode_decimal' => '8364',
                'unicode_hex'     => '20ac',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            45  => array(
                'id'              => '46',
                'code'            => 'FJD',
                'name'            => 'Fiji Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            46  => array(
                'id'              => '47',
                'code'            => 'FKP',
                'name'            => 'Falkland Islands (Malvinas) Pound',
                'html_entity'     => '&#163;',
                'font_arial'      => '£',
                'font_code2000'   => '£',
                'unicode_decimal' => '163',
                'unicode_hex'     => 'a3',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            47  => array(
                'id'              => '48',
                'code'            => 'GBP',
                'name'            => 'United Kingdom Pound',
                'html_entity'     => '&#163;',
                'font_arial'      => '£',
                'font_code2000'   => '£',
                'unicode_decimal' => '163',
                'unicode_hex'     => 'a3',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            48  => array(
                'id'              => '49',
                'code'            => 'GEL',
                'name'            => 'Georgia Lari',
                'html_entity'     => '&#4314;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            49  => array(
                'id'              => '50',
                'code'            => 'GGP',
                'name'            => 'Guernsey Pound',
                'html_entity'     => null,
                'font_arial'      => '£',
                'font_code2000'   => '£',
                'unicode_decimal' => '163',
                'unicode_hex'     => 'a3',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            50  => array(
                'id'              => '51',
                'code'            => 'GHC',
                'name'            => 'Ghana Cedi',
                'html_entity'     => '&#x47;&#x48;&#xA2;',
                'font_arial'      => 'GH¢',
                'font_code2000'   => 'GH¢',
                'unicode_decimal' => '162',
                'unicode_hex'     => 'a2',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            51  => array(
                'id'              => '52',
                'code'            => 'GHS',
                'name'            => 'Ghana Cedi',
                'html_entity'     => '&#x47;&#x48;&#xA2;',
                'font_arial'      => 'GH¢',
                'font_code2000'   => 'GH¢',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            52  => array(
                'id'              => '53',
                'code'            => 'GIP',
                'name'            => 'Gibraltar Pound',
                'html_entity'     => '&#163;',
                'font_arial'      => '£',
                'font_code2000'   => '£',
                'unicode_decimal' => '163',
                'unicode_hex'     => 'a3',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            53  => array(
                'id'              => '54',
                'code'            => 'GMD',
                'name'            => 'Gambia Dalasi',
                'html_entity'     => '&#68;',
                'font_arial'      => 'D',
                'font_code2000'   => 'D',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            54  => array(
                'id'              => '55',
                'code'            => 'GNF',
                'name'            => 'Guinea Franc',
                'html_entity'     => '&#70;&#71;',
                'font_arial'      => 'Fr',
                'font_code2000'   => 'Fr',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            55  => array(
                'id'              => '56',
                'code'            => 'GTQ',
                'name'            => 'Guatemala Quetzal',
                'html_entity'     => '&#81;',
                'font_arial'      => 'Q',
                'font_code2000'   => 'Q',
                'unicode_decimal' => '81',
                'unicode_hex'     => '51',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            56  => array(
                'id'              => '57',
                'code'            => 'GYD',
                'name'            => 'Guyana Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            57  => array(
                'id'              => '58',
                'code'            => 'HKD',
                'name'            => 'Hong Kong Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            58  => array(
                'id'              => '59',
                'code'            => 'HNL',
                'name'            => 'Honduras Lempira',
                'html_entity'     => '&#76;',
                'font_arial'      => 'L',
                'font_code2000'   => 'L',
                'unicode_decimal' => '76',
                'unicode_hex'     => '4c',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            59  => array(
                'id'              => '60',
                'code'            => 'HRK',
                'name'            => 'Croatia Kuna',
                'html_entity'     => '&#107;&#110;',
                'font_arial'      => 'kn',
                'font_code2000'   => 'kn',
                'unicode_decimal' => '107, ',
                'unicode_hex'     => '6b, 6',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            60  => array(
                'id'              => '61',
                'code'            => 'HTG',
                'name'            => 'Haiti Gourde',
                'html_entity'     => '&#71;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            61  => array(
                'id'              => '62',
                'code'            => 'HUF',
                'name'            => 'Hungary Forint',
                'html_entity'     => '&#70;&#116;',
                'font_arial'      => 'Ft',
                'font_code2000'   => 'Ft',
                'unicode_decimal' => '70, 1',
                'unicode_hex'     => '46, 7',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            62  => array(
                'id'              => '63',
                'code'            => 'IDR',
                'name'            => 'Indonesia Rupiah',
                'html_entity'     => '&#82;&#112;',
                'font_arial'      => 'Rp',
                'font_code2000'   => 'Rp',
                'unicode_decimal' => '82, 1',
                'unicode_hex'     => '52, 7',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            63  => array(
                'id'              => '64',
                'code'            => 'ILS',
                'name'            => 'Israel Shekel',
                'html_entity'     => '&#8362;',
                'font_arial'      => '₪',
                'font_code2000'   => '₪',
                'unicode_decimal' => '8362',
                'unicode_hex'     => '20aa',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            64  => array(
                'id'              => '65',
                'code'            => 'IMP',
                'name'            => 'Isle of Man Pound',
                'html_entity'     => null,
                'font_arial'      => '£',
                'font_code2000'   => '£',
                'unicode_decimal' => '163',
                'unicode_hex'     => 'a3',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            65  => array(
                'id'              => '66',
                'code'            => 'INR',
                'name'            => 'India Rupee',
                'html_entity'     => '&#8377;',
                'font_arial'      => '',
                'font_code2000'   => '',
                'unicode_decimal' => '',
                'unicode_hex'     => '',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            66  => array(
                'id'              => '67',
                'code'            => 'IQD',
                'name'            => 'Iraq Dinar',
                'html_entity'     => '&#1593;.&#1583;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            67  => array(
                'id'              => '68',
                'code'            => 'IRR',
                'name'            => 'Iran Rial',
                'html_entity'     => '&#65020;',
                'font_arial'      => '﷼',
                'font_code2000'   => '﷼',
                'unicode_decimal' => '65020',
                'unicode_hex'     => 'fdfc',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            68  => array(
                'id'              => '69',
                'code'            => 'ISK',
                'name'            => 'Iceland Krona',
                'html_entity'     => '&#107;&#114;',
                'font_arial'      => 'kr',
                'font_code2000'   => 'kr',
                'unicode_decimal' => '107, ',
                'unicode_hex'     => '6b, 7',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            69  => array(
                'id'              => '70',
                'code'            => 'JEP',
                'name'            => 'Jersey Pound',
                'html_entity'     => '&#163;',
                'font_arial'      => '£',
                'font_code2000'   => '£',
                'unicode_decimal' => '163',
                'unicode_hex'     => 'a3',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            70  => array(
                'id'              => '71',
                'code'            => 'JMD',
                'name'            => 'Jamaica Dollar',
                'html_entity'     => '&#74;&#36;',
                'font_arial'      => 'J$',
                'font_code2000'   => 'J$',
                'unicode_decimal' => '74, 3',
                'unicode_hex'     => '4a, 2',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            71  => array(
                'id'              => '72',
                'code'            => 'JOD',
                'name'            => 'Jordan Dinar',
                'html_entity'     => '&#74;&#68;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            72  => array(
                'id'              => '73',
                'code'            => 'JPY',
                'name'            => 'Japan Yen',
                'html_entity'     => '&#165;',
                'font_arial'      => '¥',
                'font_code2000'   => '¥',
                'unicode_decimal' => '165',
                'unicode_hex'     => 'a5',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            73  => array(
                'id'              => '74',
                'code'            => 'KES',
                'name'            => 'Kenya Shilling',
                'html_entity'     => '&#x4B;&#x53;&#x68;',
                'font_arial'      => 'KSh',
                'font_code2000'   => 'KSh',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            74  => array(
                'id'              => '75',
                'code'            => 'KGS',
                'name'            => 'Kyrgyzstan Som',
                'html_entity'     => '&#1083;&#1074;',
                'font_arial'      => 'лв',
                'font_code2000'   => 'лв',
                'unicode_decimal' => '1083,',
                'unicode_hex'     => '43b, ',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            75  => array(
                'id'              => '76',
                'code'            => 'KHR',
                'name'            => 'Cambodia Riel',
                'html_entity'     => '&#6107;',
                'font_arial'      => '៛',
                'font_code2000'   => '៛',
                'unicode_decimal' => '6107',
                'unicode_hex'     => '17db',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            76  => array(
                'id'              => '77',
                'code'            => 'KMF',
                'name'            => 'Comoros Franc',
                'html_entity'     => '&#67;&#70;',
                'font_arial'      => 'Fr',
                'font_code2000'   => 'Fr',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            77  => array(
                'id'              => '78',
                'code'            => 'KPW',
                'name'            => 'Korea (North) Won',
                'html_entity'     => '&#8361;',
                'font_arial'      => '₩',
                'font_code2000'   => '₩',
                'unicode_decimal' => '8361',
                'unicode_hex'     => '20a9',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            78  => array(
                'id'              => '79',
                'code'            => 'KRW',
                'name'            => 'Korea (South) Won',
                'html_entity'     => '&#8361;',
                'font_arial'      => '₩',
                'font_code2000'   => '₩',
                'unicode_decimal' => '8361',
                'unicode_hex'     => '20a9',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            79  => array(
                'id'              => '80',
                'code'            => 'KWD',
                'name'            => 'Kuwait Dinar',
                'html_entity'     => '&#1583;.&#1603;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            80  => array(
                'id'              => '81',
                'code'            => 'KYD',
                'name'            => 'Cayman Islands Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            81  => array(
                'id'              => '82',
                'code'            => 'KZT',
                'name'            => 'Kazakhstan Tenge',
                'html_entity'     => '&#1083;&#1074;',
                'font_arial'      => 'лв',
                'font_code2000'   => 'лв',
                'unicode_decimal' => '1083,',
                'unicode_hex'     => '43b, ',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            82  => array(
                'id'              => '83',
                'code'            => 'LAK',
                'name'            => 'Laos Kip',
                'html_entity'     => '&#8365;',
                'font_arial'      => '₭',
                'font_code2000'   => '₭',
                'unicode_decimal' => '8365',
                'unicode_hex'     => '20ad',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            83  => array(
                'id'              => '84',
                'code'            => 'LBP',
                'name'            => 'Lebanon Pound',
                'html_entity'     => '&#163;',
                'font_arial'      => '£',
                'font_code2000'   => '£',
                'unicode_decimal' => '163',
                'unicode_hex'     => 'a3',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            84  => array(
                'id'              => '85',
                'code'            => 'LKR',
                'name'            => 'Sri Lanka Rupee',
                'html_entity'     => '&#8360;',
                'font_arial'      => '₨',
                'font_code2000'   => '₨',
                'unicode_decimal' => '8360',
                'unicode_hex'     => '20a8',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            85  => array(
                'id'              => '86',
                'code'            => 'LRD',
                'name'            => 'Liberia Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            86  => array(
                'id'              => '87',
                'code'            => 'LSL',
                'name'            => 'Lesotho Loti',
                'html_entity'     => '&#76;',
                'font_arial'      => 'M',
                'font_code2000'   => 'M',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            87  => array(
                'id'              => '88',
                'code'            => 'LTL',
                'name'            => 'Lithuania Litas',
                'html_entity'     => '&#76;&#116;',
                'font_arial'      => 'Lt',
                'font_code2000'   => 'Lt',
                'unicode_decimal' => '76, 1',
                'unicode_hex'     => '4c, 7',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            88  => array(
                'id'              => '89',
                'code'            => 'LVL',
                'name'            => 'Latvia Lat',
                'html_entity'     => '&#76;&#115;',
                'font_arial'      => 'Ls',
                'font_code2000'   => 'Ls',
                'unicode_decimal' => '76, 1',
                'unicode_hex'     => '4c, 7',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            89  => array(
                'id'              => '90',
                'code'            => 'LYD',
                'name'            => 'Libya Dinar',
                'html_entity'     => '&#1604;.&#1583;',
                'font_arial'      => 'DL',
                'font_code2000'   => 'DL',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            90  => array(
                'id'              => '91',
                'code'            => 'MAD',
                'name'            => 'Morocco Dirham',
                'html_entity'     => '&#1583;.&#1605;.',
                'font_arial'      => 'Dhs',
                'font_code2000'   => 'Dhs',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            91  => array(
                'id'              => '92',
                'code'            => 'MDL',
                'name'            => 'Moldova Leu',
                'html_entity'     => '&#76;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            92  => array(
                'id'              => '93',
                'code'            => 'MGA',
                'name'            => 'Madagascar Ariary',
                'html_entity'     => '&#65;&#114;',
                'font_arial'      => 'Ar',
                'font_code2000'   => 'Ar',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            93  => array(
                'id'              => '94',
                'code'            => 'MKD',
                'name'            => 'Macedonia Denar',
                'html_entity'     => '&#1076;&#1077;&#1085;',
                'font_arial'      => 'ден',
                'font_code2000'   => 'ден',
                'unicode_decimal' => '1076,',
                'unicode_hex'     => '434, ',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            94  => array(
                'id'              => '95',
                'code'            => 'MMK',
                'name'            => 'Myanmar (Burma) Kyat',
                'html_entity'     => '&#75;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            95  => array(
                'id'              => '96',
                'code'            => 'MNT',
                'name'            => 'Mongolia Tughrik',
                'html_entity'     => '&#8366;',
                'font_arial'      => '₮',
                'font_code2000'   => '₮',
                'unicode_decimal' => '8366',
                'unicode_hex'     => '20ae',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            96  => array(
                'id'              => '97',
                'code'            => 'MOP',
                'name'            => 'Macau Pataca',
                'html_entity'     => '&#77;&#79;&#80;&#36;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            97  => array(
                'id'              => '98',
                'code'            => 'MRO',
                'name'            => 'Mauritania Ouguiya',
                'html_entity'     => '&#85;&#77;',
                'font_arial'      => 'UM',
                'font_code2000'   => 'UM',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            98  => array(
                'id'              => '99',
                'code'            => 'MUR',
                'name'            => 'Mauritius Rupee',
                'html_entity'     => '&#8360;',
                'font_arial'      => '₨',
                'font_code2000'   => '₨',
                'unicode_decimal' => '8360',
                'unicode_hex'     => '20a8',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            99  => array(
                'id'              => '100',
                'code'            => 'MVR',
                'name'            => 'Maldives (Maldive Islands) Rufiyaa',
                'html_entity'     => '.&#1923;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            100 => array(
                'id'              => '101',
                'code'            => 'MWK',
                'name'            => 'Malawi Kwacha',
                'html_entity'     => '&#77;&#75;',
                'font_arial'      => 'MK',
                'font_code2000'   => 'MK',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            101 => array(
                'id'              => '102',
                'code'            => 'MXN',
                'name'            => 'Mexico Peso',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            102 => array(
                'id'              => '103',
                'code'            => 'MYR',
                'name'            => 'Malaysia Ringgit',
                'html_entity'     => '&#82;&#77;',
                'font_arial'      => 'RM',
                'font_code2000'   => 'RM',
                'unicode_decimal' => '82, 7',
                'unicode_hex'     => '52, 4',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            103 => array(
                'id'              => '104',
                'code'            => 'MZN',
                'name'            => 'Mozambique Metical',
                'html_entity'     => '&#77;&#84;',
                'font_arial'      => 'MT',
                'font_code2000'   => 'MT',
                'unicode_decimal' => '77, 8',
                'unicode_hex'     => '4d, 5',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            104 => array(
                'id'              => '105',
                'code'            => 'NAD',
                'name'            => 'Namibia Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            105 => array(
                'id'              => '106',
                'code'            => 'NGN',
                'name'            => 'Nigeria Naira',
                'html_entity'     => '&#8358;',
                'font_arial'      => '₦',
                'font_code2000'   => '₦',
                'unicode_decimal' => '8358',
                'unicode_hex'     => '20a6',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            106 => array(
                'id'              => '107',
                'code'            => 'NIO',
                'name'            => 'Nicaragua Cordoba',
                'html_entity'     => '&#67;&#36;',
                'font_arial'      => 'C$',
                'font_code2000'   => 'C$',
                'unicode_decimal' => '67, 3',
                'unicode_hex'     => '43, 2',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            107 => array(
                'id'              => '108',
                'code'            => 'NOK',
                'name'            => 'Norway Krone',
                'html_entity'     => '&#107;&#114;',
                'font_arial'      => 'kr',
                'font_code2000'   => 'kr',
                'unicode_decimal' => '107, ',
                'unicode_hex'     => '6b, 7',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            108 => array(
                'id'              => '109',
                'code'            => 'NPR',
                'name'            => 'Nepal Rupee',
                'html_entity'     => '&#8360;',
                'font_arial'      => '₨',
                'font_code2000'   => '₨',
                'unicode_decimal' => '8360',
                'unicode_hex'     => '20a8',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            109 => array(
                'id'              => '110',
                'code'            => 'NZD',
                'name'            => 'New Zealand Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            110 => array(
                'id'              => '111',
                'code'            => 'OMR',
                'name'            => 'Oman Rial',
                'html_entity'     => '&#65020;',
                'font_arial'      => '﷼',
                'font_code2000'   => '﷼',
                'unicode_decimal' => '65020',
                'unicode_hex'     => 'fdfc',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            111 => array(
                'id'              => '112',
                'code'            => 'PAB',
                'name'            => 'Panama Balboa',
                'html_entity'     => '&#66;&#47;&#46;',
                'font_arial'      => 'B/.',
                'font_code2000'   => 'B/.',
                'unicode_decimal' => '66, 4',
                'unicode_hex'     => '42, 2',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            112 => array(
                'id'              => '113',
                'code'            => 'PEN',
                'name'            => 'Peru Nuevo Sol',
                'html_entity'     => '&#83;&#47;&#46;',
                'font_arial'      => 'S/.',
                'font_code2000'   => 'S/.',
                'unicode_decimal' => '83, 4',
                'unicode_hex'     => '53, 2',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            113 => array(
                'id'              => '114',
                'code'            => 'PGK',
                'name'            => 'Papua New Guinea Kina',
                'html_entity'     => '&#75;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            114 => array(
                'id'              => '115',
                'code'            => 'PHP',
                'name'            => 'Philippines Peso',
                'html_entity'     => '&#8369;',
                'font_arial'      => '₱',
                'font_code2000'   => '₱',
                'unicode_decimal' => '8369',
                'unicode_hex'     => '20b1',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            115 => array(
                'id'              => '116',
                'code'            => 'PKR',
                'name'            => 'Pakistan Rupee',
                'html_entity'     => '&#8360;',
                'font_arial'      => '₨',
                'font_code2000'   => '₨',
                'unicode_decimal' => '8360',
                'unicode_hex'     => '20a8',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            116 => array(
                'id'              => '117',
                'code'            => 'PLN',
                'name'            => 'Poland Zloty',
                'html_entity'     => '&#122;&#322;',
                'font_arial'      => 'zł',
                'font_code2000'   => 'zł',
                'unicode_decimal' => '122, ',
                'unicode_hex'     => '7a, 1',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            117 => array(
                'id'              => '118',
                'code'            => 'PYG',
                'name'            => 'Paraguay Guarani',
                'html_entity'     => '&#71;&#115;',
                'font_arial'      => 'Gs',
                'font_code2000'   => 'Gs',
                'unicode_decimal' => '71, 1',
                'unicode_hex'     => '47, 7',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            118 => array(
                'id'              => '119',
                'code'            => 'QAR',
                'name'            => 'Qatar Riyal',
                'html_entity'     => '&#65020;',
                'font_arial'      => '﷼',
                'font_code2000'   => '﷼',
                'unicode_decimal' => '65020',
                'unicode_hex'     => 'fdfc',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            119 => array(
                'id'              => '120',
                'code'            => 'RON',
                'name'            => 'Romania New Leu',
                'html_entity'     => '&#108;&#101;&#105;',
                'font_arial'      => 'lei',
                'font_code2000'   => 'lei',
                'unicode_decimal' => '108, ',
                'unicode_hex'     => '6c, 6',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            120 => array(
                'id'              => '121',
                'code'            => 'RSD',
                'name'            => 'Serbia Dinar',
                'html_entity'     => '&#1044;&#1080;&#1085;&#46;',
                'font_arial'      => 'Дин.',
                'font_code2000'   => 'Дин.',
                'unicode_decimal' => '1044,',
                'unicode_hex'     => '414, ',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            121 => array(
                'id'              => '122',
                'code'            => 'RUB',
                'name'            => 'Russia Ruble',
                'html_entity'     => '&#1088;&#1091;&#1073;',
                'font_arial'      => 'руб',
                'font_code2000'   => 'руб',
                'unicode_decimal' => '1088,',
                'unicode_hex'     => '440, ',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            122 => array(
                'id'              => '123',
                'code'            => 'RWF',
                'name'            => 'Rwanda Franc',
                'html_entity'     => '&#1585;.&#1587;',
                'font_arial'      => 'FRw',
                'font_code2000'   => 'FRw',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            123 => array(
                'id'              => '124',
                'code'            => 'SAR',
                'name'            => 'Saudi Arabia Riyal',
                'html_entity'     => '&#65020;',
                'font_arial'      => '﷼',
                'font_code2000'   => '﷼',
                'unicode_decimal' => '65020',
                'unicode_hex'     => 'fdfc',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            124 => array(
                'id'              => '125',
                'code'            => 'SBD',
                'name'            => 'Solomon Islands Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            125 => array(
                'id'              => '126',
                'code'            => 'SCR',
                'name'            => 'Seychelles Rupee',
                'html_entity'     => '&#8360;',
                'font_arial'      => '₨',
                'font_code2000'   => '₨',
                'unicode_decimal' => '8360',
                'unicode_hex'     => '20a8',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            126 => array(
                'id'              => '127',
                'code'            => 'SDG',
                'name'            => 'Sudan Pound',
                'html_entity'     => '&#163;',
                'font_arial'      => 'DS',
                'font_code2000'   => 'DS',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            127 => array(
                'id'              => '128',
                'code'            => 'SEK',
                'name'            => 'Sweden Krona',
                'html_entity'     => '&#107;&#114;',
                'font_arial'      => 'kr',
                'font_code2000'   => 'kr',
                'unicode_decimal' => '107, ',
                'unicode_hex'     => '6b, 7',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            128 => array(
                'id'              => '129',
                'code'            => 'SGD',
                'name'            => 'Singapore Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            129 => array(
                'id'              => '130',
                'code'            => 'SHP',
                'name'            => 'Saint Helena Pound',
                'html_entity'     => '&#163;',
                'font_arial'      => '£',
                'font_code2000'   => '£',
                'unicode_decimal' => '163',
                'unicode_hex'     => 'a3',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            130 => array(
                'id'              => '131',
                'code'            => 'SLL',
                'name'            => 'Sierra Leone Leone',
                'html_entity'     => '&#76;&#101;',
                'font_arial'      => 'Le',
                'font_code2000'   => 'Le',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            131 => array(
                'id'              => '132',
                'code'            => 'SOS',
                'name'            => 'Somalia Shilling',
                'html_entity'     => '&#83;',
                'font_arial'      => 'S',
                'font_code2000'   => 'S',
                'unicode_decimal' => '83',
                'unicode_hex'     => '53',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            132 => array(
                'id'              => '133',
                'code'            => 'SPL',
                'name'            => 'Seborga Luigino',
                'html_entity'     => null,
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            133 => array(
                'id'              => '134',
                'code'            => 'SRD',
                'name'            => 'Suriname Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            134 => array(
                'id'              => '135',
                'code'            => 'SSP',
                'name'            => 'South Sudanese Pound',
                'html_entity'     => '&#xA3;',
                'font_arial'      => '£',
                'font_code2000'   => '£',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            135 => array(
                'id'              => '136',
                'code'            => 'STD',
                'name'            => 'São Tomé and Príncipe Dobra',
                'html_entity'     => '&#68;&#98;',
                'font_arial'      => 'Db',
                'font_code2000'   => 'Db',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            136 => array(
                'id'              => '137',
                'code'            => 'SVC',
                'name'            => 'El Salvador Colon',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            137 => array(
                'id'              => '138',
                'code'            => 'SYP',
                'name'            => 'Syria Pound',
                'html_entity'     => '&#163;',
                'font_arial'      => '£',
                'font_code2000'   => '£',
                'unicode_decimal' => '163',
                'unicode_hex'     => 'a3',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            138 => array(
                'id'              => '139',
                'code'            => 'SZL',
                'name'            => 'Swaziland Lilangeni',
                'html_entity'     => '&#76;',
                'font_arial'      => 'E',
                'font_code2000'   => 'E',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            139 => array(
                'id'              => '140',
                'code'            => 'THB',
                'name'            => 'Thailand Baht',
                'html_entity'     => '&#3647;',
                'font_arial'      => '฿',
                'font_code2000'   => '฿',
                'unicode_decimal' => '3647',
                'unicode_hex'     => 'e3f',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            140 => array(
                'id'              => '141',
                'code'            => 'TJS',
                'name'            => 'Tajikistan Somoni',
                'html_entity'     => '&#84;&#74;&#83;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            141 => array(
                'id'              => '142',
                'code'            => 'TMT',
                'name'            => 'Turkmenistan Manat',
                'html_entity'     => '&#109;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            142 => array(
                'id'              => '143',
                'code'            => 'TND',
                'name'            => 'Tunisia Dinar',
                'html_entity'     => '&#1583;.&#1578;',
                'font_arial'      => 'DT',
                'font_code2000'   => 'DT',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            143 => array(
                'id'              => '144',
                'code'            => 'TOP',
                'name'            => 'Tonga Pa\'anga',
                'html_entity'     => '&#84;&#36;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            144 => array(
                'id'              => '145',
                'code'            => 'TRL',
                'name'            => 'Turkey Lira',
                'html_entity'     => null,
                'font_arial'      => '₤',
                'font_code2000'   => '₤',
                'unicode_decimal' => '8356',
                'unicode_hex'     => '20a4',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            145 => array(
                'id'              => '146',
                'code'            => 'TRY',
                'name'            => 'Turkey Lira',
                'html_entity'     => '&#x20BA;',
                'font_arial'      => '₺',
                'font_code2000'   => '₺',
                'unicode_decimal' => '',
                'unicode_hex'     => '',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            146 => array(
                'id'              => '147',
                'code'            => 'TTD',
                'name'            => 'Trinidad and Tobago Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => 'TT$',
                'font_code2000'   => 'TT$',
                'unicode_decimal' => '84, 8',
                'unicode_hex'     => '54, 5',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            147 => array(
                'id'              => '148',
                'code'            => 'TVD',
                'name'            => 'Tuvalu Dollar',
                'html_entity'     => null,
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            148 => array(
                'id'              => '149',
                'code'            => 'TWD',
                'name'            => 'Taiwan New Dollar',
                'html_entity'     => '&#78;&#84;&#36;',
                'font_arial'      => 'NT$',
                'font_code2000'   => 'NT$',
                'unicode_decimal' => '78, 8',
                'unicode_hex'     => '4e, 5',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            149 => array(
                'id'              => '150',
                'code'            => 'TZS',
                'name'            => 'Tanzania Shilling',
                'html_entity'     => '&#x54;&#x53;&#x68;',
                'font_arial'      => 'TSh',
                'font_code2000'   => 'TSh',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            150 => array(
                'id'              => '151',
                'code'            => 'UAH',
                'name'            => 'Ukraine Hryvnia',
                'html_entity'     => '&#8372;',
                'font_arial'      => '₴',
                'font_code2000'   => '₴',
                'unicode_decimal' => '8372',
                'unicode_hex'     => '20b4',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            151 => array(
                'id'              => '152',
                'code'            => 'UGX',
                'name'            => 'Uganda Shilling',
                'html_entity'     => '&#85;&#83;&#104;',
                'font_arial'      => 'USh',
                'font_code2000'   => 'USh',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            152 => array(
                'id'              => '153',
                'code'            => 'USD',
                'name'            => 'United States Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            153 => array(
                'id'              => '154',
                'code'            => 'UYU',
                'name'            => 'Uruguay Peso',
                'html_entity'     => '&#36;&#85;',
                'font_arial'      => '$U',
                'font_code2000'   => '$U',
                'unicode_decimal' => '36, 8',
                'unicode_hex'     => '24, 5',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            154 => array(
                'id'              => '155',
                'code'            => 'UZS',
                'name'            => 'Uzbekistan Som',
                'html_entity'     => '&#1083;&#1074;',
                'font_arial'      => 'лв',
                'font_code2000'   => 'лв',
                'unicode_decimal' => '1083,',
                'unicode_hex'     => '43b, ',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            155 => array(
                'id'              => '156',
                'code'            => 'VEF',
                'name'            => 'Venezuela Bolivar',
                'html_entity'     => '&#66;&#115;',
                'font_arial'      => 'Bs',
                'font_code2000'   => 'Bs',
                'unicode_decimal' => '66, 1',
                'unicode_hex'     => '42, 7',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            156 => array(
                'id'              => '157',
                'code'            => 'VND',
                'name'            => 'Viet Nam Dong',
                'html_entity'     => '&#8363;',
                'font_arial'      => '₫',
                'font_code2000'   => '₫',
                'unicode_decimal' => '8363',
                'unicode_hex'     => '20ab',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            157 => array(
                'id'              => '158',
                'code'            => 'VUV',
                'name'            => 'Vanuatu Vatu',
                'html_entity'     => '&#86;&#84;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            158 => array(
                'id'              => '159',
                'code'            => 'WST',
                'name'            => 'Samoa Tala',
                'html_entity'     => '&#87;&#83;&#36;',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            159 => array(
                'id'              => '160',
                'code'            => 'XAF',
                'name'            => 'Communauté Financière Africaine (BEAC) CFA Franc B',
                'html_entity'     => '&#70;&#67;&#70;&#65;',
                'font_arial'      => 'F',
                'font_code2000'   => 'F',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            160 => array(
                'id'              => '161',
                'code'            => 'XCD',
                'name'            => 'East Caribbean Dollar',
                'html_entity'     => '&#36;',
                'font_arial'      => '$',
                'font_code2000'   => '$',
                'unicode_decimal' => '36',
                'unicode_hex'     => '24',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            161 => array(
                'id'              => '162',
                'code'            => 'XDR',
                'name'            => 'International Monetary Fund (IMF) Special Drawing ',
                'html_entity'     => '',
                'font_arial'      => null,
                'font_code2000'   => null,
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            162 => array(
                'id'              => '163',
                'code'            => 'XOF',
                'name'            => 'Communauté Financière Africaine (BCEAO) Franc',
                'html_entity'     => '&#70;&#67;&#70;&#65;',
                'font_arial'      => 'F',
                'font_code2000'   => 'F',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            163 => array(
                'id'              => '164',
                'code'            => 'XPF',
                'name'            => 'Comptoirs Français du Pacifique (CFP) Franc',
                'html_entity'     => '&#70;',
                'font_arial'      => 'F',
                'font_code2000'   => 'F',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            164 => array(
                'id'              => '165',
                'code'            => 'YER',
                'name'            => 'Yemen Rial',
                'html_entity'     => '&#65020;',
                'font_arial'      => '﷼',
                'font_code2000'   => '﷼',
                'unicode_decimal' => '65020',
                'unicode_hex'     => 'fdfc',
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            165 => array(
                'id'              => '166',
                'code'            => 'ZAR',
                'name'            => 'South Africa Rand',
                'html_entity'     => '&#82;',
                'font_arial'      => 'R',
                'font_code2000'   => 'R',
                'unicode_decimal' => '82',
                'unicode_hex'     => '52',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => '2016-04-03 15:35:01',
            ),
            166 => array(
                'id'              => '167',
                'code'            => 'ZMW',
                'name'            => 'Zambia Kwacha',
                'html_entity'     => null,
                'font_arial'      => 'ZK',
                'font_code2000'   => 'ZK',
                'unicode_decimal' => null,
                'unicode_hex'     => null,
                'in_left'         => '0',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            167 => array(
                'id'              => '168',
                'code'            => 'ZWD',
                'name'            => 'Zimbabwe Dollar',
                'html_entity'     => null,
                'font_arial'      => 'Z$',
                'font_code2000'   => 'Z$',
                'unicode_decimal' => '90, 3',
                'unicode_hex'     => '5a, 2',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => null,
            ),
            168 => array(
                'id'              => '169',
                'code'            => 'ZWL',
                'name'            => 'Zimbabwe Dollar',
                'html_entity'     => null,
                'font_arial'      => 'Z$',
                'font_code2000'   => 'Z$',
                'unicode_decimal' => '90, 3',
                'unicode_hex'     => '5a, 2',
                'in_left'         => '1',
                'created_at'      => null,
                'updated_at'      => null,
            ),
        ));
    }
}
