<?php
/**
 * LaraClassified - Geo Classified Ads CMS
 * Copyright (c) Mayeul Akpovi. All Rights Reserved
 *
 * Email: mayeul.a@larapen.com
 * Website: http://larapen.com
 *
 * LICENSE
 * -------
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the inclusion
 * of the above copyright notice. If you Purchased from Codecanyon,
 * Please read the full License from here - http://codecanyon.net/licenses/standard
 */

use Illuminate\Database\Seeder;

class SettingsTableSeeder extends Seeder
{
    /**
     * Insert data
     *
     * @return void
     */
    public function run()
    {
        \DB::table('settings')->delete();
        
        \DB::table('settings')->insert(array(
            0  => array(
                'id'          => '1',
                'key'         => 'app_name',
                'name'        => 'App Name',
                'value'       => 'LaraClassified',
                'description' => 'Website name',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '2',
                'rgt'         => '3',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 01:43:31',
            ),
            1  => array(
                'id'          => '2',
                'key'         => 'app_logo',
                'name'        => 'Logo',
                'value'       => '',
                'description' => 'Website Logo',
                'field'       => '{"name":"value","label":"Value","type":"browse"}',
                'parent_id'   => '0',
                'lft'         => '4',
                'rgt'         => '5',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            2  => array(
                'id'          => '3',
                'key'         => 'app_slogan',
                'name'        => 'App Slogan',
                'value'       => 'LaraClassified - Geo Classified Ads CMS',
                'description' => 'Website slogan (for Meta Title)',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '6',
                'rgt'         => '7',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 01:43:39',
            ),
            3  => array(
                'id'          => '4',
                'key'         => 'app_theme',
                'name'        => 'Theme',
                'value'       => '',
                'description' => 'Supported: blue, yellow, green, red (or empty)',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '8',
                'rgt'         => '9',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            4  => array(
                'id'          => '5',
                'key'         => 'app_email',
                'name'        => 'Email',
                'value'       => 'contact@larapen.com',
                'description' => 'The email address that all emails from the contact form will go to.',
                'field'       => '{"name":"value","label":"Value","type":"email"}',
                'parent_id'   => '0',
                'lft'         => '10',
                'rgt'         => '11',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            5  => array(
                'id'          => '6',
                'key'         => 'app_phone_number',
                'name'        => 'Phone number',
                'value'       => '(+229) 220-412-68',
                'description' => 'Website phone number',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '12',
                'rgt'         => '13',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            6  => array(
                'id'          => '7',
                'key'         => 'activation_geolocalization',
                'name'        => 'Geolocalization activation',
                'value'       => '1',
                'description' => 'Geolocalization activation',
                'field'       => '{"name":"value","label":"Activation","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '14',
                'rgt'         => '15',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            7  => array(
                'id'          => '8',
                'key'         => 'app_default_country',
                'name'        => 'Default Country',
                'value'       => 'CA',
                'description' => 'Default country (Enter a Country ISO Code - E.g. US)',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '16',
                'rgt'         => '17',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            8  => array(
                'id'          => '9',
                'key'         => 'activation_country_flag',
                'name'        => 'Show country flag on top',
                'value'       => '1',
                'description' => 'Show country flag on top page',
                'field'       => '{"name":"value","label":"Activation","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '18',
                'rgt'         => '19',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            9  => array(
                'id'          => '10',
                'key'         => 'activation_guests_can_post',
                'name'        => 'Guests can post Ads',
                'value'       => '1',
                'description' => 'Guest can post Ad',
                'field'       => '{"name":"value","label":"Activation","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '20',
                'rgt'         => '21',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            10 => array(
                'id'          => '11',
                'key'         => 'require_users_activation',
                'name'        => 'Users activation required',
                'value'       => '1',
                'description' => 'Users activation required',
                'field'       => '{"name":"value","label":"Required","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '22',
                'rgt'         => '23',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            11 => array(
                'id'          => '12',
                'key'         => 'activation_social_login',
                'name'        => 'Social Login Activation',
                'value'       => '1',
                'description' => 'Allow users to connect via social networks',
                'field'       => '{"name":"value","label":"Required","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '24',
                'rgt'         => '25',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            12 => array(
                'id'          => '13',
                'key'         => 'require_ads_activation',
                'name'        => 'Ads activation required',
                'value'       => '1',
                'description' => 'Ads activation required',
                'field'       => '{"name":"value","label":"Required","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '26',
                'rgt'         => '27',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            13 => array(
                'id'          => '14',
                'key'         => 'activation_facebook_comments',
                'name'        => 'Facebook Comments activation',
                'value'       => '1',
                'description' => 'Allow Facebook comments on single page',
                'field'       => '{"name":"value","label":"Required","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '28',
                'rgt'         => '29',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            14 => array(
                'id'          => '15',
                'key'         => 'show_powered_by',
                'name'        => 'Show Powered by',
                'value'       => '1',
                'description' => 'Show Powered by infos',
                'field'       => '{"name":"value","label":"Activation","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '30',
                'rgt'         => '31',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            15 => array(
                'id'          => '16',
                'key'         => 'activation_home_stats',
                'name'        => 'Show Homepage Stats',
                'value'       => '1',
                'description' => 'Show Homepage Stats (bottom page)',
                'field'       => '{"name":"value","label":"Activation","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '32',
                'rgt'         => '33',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            16 => array(
                'id'          => '17',
                'key'         => 'activation_serp_left_sidebar',
                'name'        => 'Search left sidebar activation',
                'value'       => '0',
                'description' => 'Search page (Left sidebar activation)',
                'field'       => '{"name":"value","label":"Activation","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '34',
                'rgt'         => '35',
                'depth'       => '1',
                'active'      => '0',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            17 => array(
                'id'          => '18',
                'key'         => 'google_site_verification',
                'name'        => 'Google site verification content',
                'value'       => null,
                'description' => 'Google site verification content',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '36',
                'rgt'         => '37',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            18 => array(
                'id'          => '19',
                'key'         => 'msvalidate',
                'name'        => 'Bing site verification content',
                'value'       => null,
                'description' => 'Bing site verification content',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '38',
                'rgt'         => '39',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            19 => array(
                'id'          => '20',
                'key'         => 'alexa_verify_id',
                'name'        => 'Alexa site verification content',
                'value'       => null,
                'description' => 'Alexa site verification content',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '40',
                'rgt'         => '41',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            20 => array(
                'id'          => '21',
                'key'         => 'seo_google_analytics',
                'name'        => 'Google Analytics\'s tracking code',
                'value'       => '<script>
(function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){
(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
})(window,document,\'script\',\'//www.google-analytics.com/analytics.js\',\'ga\');

ga(\'create\', \'UA-36734754-6\', \'auto\');
ga(\'send\', \'pageview\');

</script>',
                'description' => 'Google Analytics\'s tracking code',
                'field'       => '{"name":"value","label":"Value","type":"textarea"}',
                'parent_id'   => '0',
                'lft'         => '42',
                'rgt'         => '43',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            21 => array(
                'id'          => '22',
                'key'         => 'facebook_page_url',
                'name'        => 'Facebook - Page URL',
                'value'       => 'https://web.facebook.com/larapencom',
                'description' => 'Website Facebook Page URL',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '44',
                'rgt'         => '45',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            22 => array(
                'id'          => '23',
                'key'         => 'facebook_page_id',
                'name'        => 'Facebook - Page ID',
                'value'       => '806182476160185',
                'description' => 'Website Facebook Page ID (Not username)',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '46',
                'rgt'         => '47',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            23 => array(
                'id'          => '24',
                'key'         => 'twitter_url',
                'name'        => 'Twitter - URL',
                'value'       => 'https://twitter.com/larapencom',
                'description' => 'Website Twitter URL',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '48',
                'rgt'         => '49',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            24 => array(
                'id'          => '25',
                'key'         => 'twitter_username',
                'name'        => 'Twitter - Username',
                'value'       => 'larapencom',
                'description' => 'Website Twitter username',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '50',
                'rgt'         => '51',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            25 => array(
                'id'          => '26',
                'key'         => 'activation_recaptcha',
                'name'        => 'Recaptcha activation',
                'value'       => '0',
                'description' => 'Recaptcha activation',
                'field'       => '{"name":"value","label":"Activation","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '52',
                'rgt'         => '53',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            26 => array(
                'id'          => '27',
                'key'         => 'app_cache_expire',
                'name'        => 'Cache Expire duration',
                'value'       => '60',
                'description' => 'Cache Expire duration (in seconde)',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '54',
                'rgt'         => '55',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            27 => array(
                'id'          => '28',
                'key'         => 'app_cookie_expire',
                'name'        => 'Cookie Expire duration',
                'value'       => '2592000',
                'description' => 'Cookie Expire duration (in seconde)',
                'field'       => '',
                'parent_id'   => '0',
                'lft'         => '56',
                'rgt'         => '57',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            28 => array(
                'id'          => '29',
                'key'         => 'activation_minify_html',
                'name'        => 'HTML Minify activation',
                'value'       => '0',
                'description' => 'Optimization - HTML Minify activation',
                'field'       => '{"name":"value","label":"Activation","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '58',
                'rgt'         => '59',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
            29 => array(
                'id'          => '30',
                'key'         => 'activation_http_cache',
                'name'        => 'HTTP Cache activation',
                'value'       => '0',
                'description' => 'Optimization - HTTP Cache activation',
                'field'       => '{"name":"value","label":"Activation","type":"checkbox"}',
                'parent_id'   => '0',
                'lft'         => '60',
                'rgt'         => '61',
                'depth'       => '1',
                'active'      => '1',
                'created_at'  => null,
                'updated_at'  => '2016-06-08 00:43:30',
            ),
        ));
    }
}
