<?php
/**
 * LaraClassified - Geo Classified Ads CMS
 * Copyright (c) Mayeul Akpovi. All Rights Reserved
 *
 * Email: mayeul.a@larapen.com
 * Website: http://larapen.com
 *
 * LICENSE
 * -------
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the inclusion
 * of the above copyright notice. If you Purchased from Codecanyon,
 * Please read the full License from here - http://codecanyon.net/licenses/standard
 */

use Illuminate\Database\Seeder;

class TimeZonesTableSeeder extends Seeder
{
    /**
     * Insert data
     *
     * @return void
     */
    public function run()
    {
        \DB::table('time_zones')->delete();
        
        \DB::table('time_zones')->insert(array(
            0   => array(
                'id'           => '1',
                'country_code' => 'AD',
                'time_zone_id' => 'Europe/Andorra',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            1   => array(
                'id'           => '2',
                'country_code' => 'AE',
                'time_zone_id' => 'Asia/Dubai',
                'gmt'          => '4',
                'dst'          => '4',
                'raw'          => '4',
            ),
            2   => array(
                'id'           => '3',
                'country_code' => 'AF',
                'time_zone_id' => 'Asia/Kabul',
                'gmt'          => '4.5',
                'dst'          => '4.5',
                'raw'          => '4.5',
            ),
            3   => array(
                'id'           => '4',
                'country_code' => 'AG',
                'time_zone_id' => 'America/Antigua',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            4   => array(
                'id'           => '5',
                'country_code' => 'AI',
                'time_zone_id' => 'America/Anguilla',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            5   => array(
                'id'           => '6',
                'country_code' => 'AL',
                'time_zone_id' => 'Europe/Tirane',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            6   => array(
                'id'           => '7',
                'country_code' => 'AM',
                'time_zone_id' => 'Asia/Yerevan',
                'gmt'          => '4',
                'dst'          => '4',
                'raw'          => '4',
            ),
            7   => array(
                'id'           => '8',
                'country_code' => 'AO',
                'time_zone_id' => 'Africa/Luanda',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            8   => array(
                'id'           => '9',
                'country_code' => 'AQ',
                'time_zone_id' => 'Antarctica/Casey',
                'gmt'          => '8',
                'dst'          => '8',
                'raw'          => '8',
            ),
            9   => array(
                'id'           => '10',
                'country_code' => 'AR',
                'time_zone_id' => 'America/Argentina/Buenos_Aires',
                'gmt'          => '-3',
                'dst'          => '-3',
                'raw'          => '-3',
            ),
            10  => array(
                'id'           => '11',
                'country_code' => 'AS',
                'time_zone_id' => 'Pacific/Pago_Pago',
                'gmt'          => '-11',
                'dst'          => '-11',
                'raw'          => '-11',
            ),
            11  => array(
                'id'           => '12',
                'country_code' => 'AT',
                'time_zone_id' => 'Europe/Vienna',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            12  => array(
                'id'           => '13',
                'country_code' => 'AU',
                'time_zone_id' => 'Antarctica/Macquarie',
                'gmt'          => '11',
                'dst'          => '11',
                'raw'          => '11',
            ),
            13  => array(
                'id'           => '14',
                'country_code' => 'AW',
                'time_zone_id' => 'America/Aruba',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            14  => array(
                'id'           => '15',
                'country_code' => 'AX',
                'time_zone_id' => 'Europe/Mariehamn',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            15  => array(
                'id'           => '16',
                'country_code' => 'AZ',
                'time_zone_id' => 'Asia/Baku',
                'gmt'          => '4',
                'dst'          => '5',
                'raw'          => '4',
            ),
            16  => array(
                'id'           => '17',
                'country_code' => 'BA',
                'time_zone_id' => 'Europe/Sarajevo',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            17  => array(
                'id'           => '18',
                'country_code' => 'BB',
                'time_zone_id' => 'America/Barbados',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            18  => array(
                'id'           => '19',
                'country_code' => 'BD',
                'time_zone_id' => 'Asia/Dhaka',
                'gmt'          => '6',
                'dst'          => '6',
                'raw'          => '6',
            ),
            19  => array(
                'id'           => '20',
                'country_code' => 'BE',
                'time_zone_id' => 'Europe/Brussels',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            20  => array(
                'id'           => '21',
                'country_code' => 'BF',
                'time_zone_id' => 'Africa/Ouagadougou',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            21  => array(
                'id'           => '22',
                'country_code' => 'BG',
                'time_zone_id' => 'Europe/Sofia',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            22  => array(
                'id'           => '23',
                'country_code' => 'BH',
                'time_zone_id' => 'Asia/Bahrain',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            23  => array(
                'id'           => '24',
                'country_code' => 'BI',
                'time_zone_id' => 'Africa/Bujumbura',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
            24  => array(
                'id'           => '25',
                'country_code' => 'BJ',
                'time_zone_id' => 'Africa/Porto-Novo',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            25  => array(
                'id'           => '26',
                'country_code' => 'BL',
                'time_zone_id' => 'America/St_Barthelemy',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            26  => array(
                'id'           => '27',
                'country_code' => 'BM',
                'time_zone_id' => 'Atlantic/Bermuda',
                'gmt'          => '-4',
                'dst'          => '-3',
                'raw'          => '-4',
            ),
            27  => array(
                'id'           => '28',
                'country_code' => 'BN',
                'time_zone_id' => 'Asia/Brunei',
                'gmt'          => '8',
                'dst'          => '8',
                'raw'          => '8',
            ),
            28  => array(
                'id'           => '29',
                'country_code' => 'BO',
                'time_zone_id' => 'America/La_Paz',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            29  => array(
                'id'           => '30',
                'country_code' => 'BQ',
                'time_zone_id' => 'America/Kralendijk',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            30  => array(
                'id'           => '31',
                'country_code' => 'BR',
                'time_zone_id' => 'America/Araguaina',
                'gmt'          => '-3',
                'dst'          => '-3',
                'raw'          => '-3',
            ),
            31  => array(
                'id'           => '32',
                'country_code' => 'BS',
                'time_zone_id' => 'America/Nassau',
                'gmt'          => '-5',
                'dst'          => '-4',
                'raw'          => '-5',
            ),
            32  => array(
                'id'           => '33',
                'country_code' => 'BT',
                'time_zone_id' => 'Asia/Thimphu',
                'gmt'          => '6',
                'dst'          => '6',
                'raw'          => '6',
            ),
            33  => array(
                'id'           => '34',
                'country_code' => 'BW',
                'time_zone_id' => 'Africa/Gaborone',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
            34  => array(
                'id'           => '35',
                'country_code' => 'BY',
                'time_zone_id' => 'Europe/Minsk',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            35  => array(
                'id'           => '36',
                'country_code' => 'BZ',
                'time_zone_id' => 'America/Belize',
                'gmt'          => '-6',
                'dst'          => '-6',
                'raw'          => '-6',
            ),
            36  => array(
                'id'           => '37',
                'country_code' => 'CA',
                'time_zone_id' => 'America/Atikokan',
                'gmt'          => '-5',
                'dst'          => '-5',
                'raw'          => '-5',
            ),
            37  => array(
                'id'           => '38',
                'country_code' => 'CC',
                'time_zone_id' => 'Indian/Cocos',
                'gmt'          => '6.5',
                'dst'          => '6.5',
                'raw'          => '6.5',
            ),
            38  => array(
                'id'           => '39',
                'country_code' => 'CD',
                'time_zone_id' => 'Africa/Kinshasa',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            39  => array(
                'id'           => '40',
                'country_code' => 'CF',
                'time_zone_id' => 'Africa/Bangui',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            40  => array(
                'id'           => '41',
                'country_code' => 'CG',
                'time_zone_id' => 'Africa/Brazzaville',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            41  => array(
                'id'           => '42',
                'country_code' => 'CH',
                'time_zone_id' => 'Europe/Zurich',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            42  => array(
                'id'           => '43',
                'country_code' => 'CI',
                'time_zone_id' => 'Africa/Abidjan',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            43  => array(
                'id'           => '44',
                'country_code' => 'CK',
                'time_zone_id' => 'Pacific/Rarotonga',
                'gmt'          => '-10',
                'dst'          => '-10',
                'raw'          => '-10',
            ),
            44  => array(
                'id'           => '45',
                'country_code' => 'CL',
                'time_zone_id' => 'America/Santiago',
                'gmt'          => '-3',
                'dst'          => '-3',
                'raw'          => '-3',
            ),
            45  => array(
                'id'           => '46',
                'country_code' => 'CM',
                'time_zone_id' => 'Africa/Douala',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            46  => array(
                'id'           => '47',
                'country_code' => 'CN',
                'time_zone_id' => 'Asia/Shanghai',
                'gmt'          => '8',
                'dst'          => '8',
                'raw'          => '8',
            ),
            47  => array(
                'id'           => '48',
                'country_code' => 'CO',
                'time_zone_id' => 'America/Bogota',
                'gmt'          => '-5',
                'dst'          => '-5',
                'raw'          => '-5',
            ),
            48  => array(
                'id'           => '49',
                'country_code' => 'CR',
                'time_zone_id' => 'America/Costa_Rica',
                'gmt'          => '-6',
                'dst'          => '-6',
                'raw'          => '-6',
            ),
            49  => array(
                'id'           => '50',
                'country_code' => 'CU',
                'time_zone_id' => 'America/Havana',
                'gmt'          => '-5',
                'dst'          => '-4',
                'raw'          => '-5',
            ),
            50  => array(
                'id'           => '51',
                'country_code' => 'CV',
                'time_zone_id' => 'Atlantic/Cape_Verde',
                'gmt'          => '-1',
                'dst'          => '-1',
                'raw'          => '-1',
            ),
            51  => array(
                'id'           => '52',
                'country_code' => 'CW',
                'time_zone_id' => 'America/Curacao',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            52  => array(
                'id'           => '53',
                'country_code' => 'CX',
                'time_zone_id' => 'Indian/Christmas',
                'gmt'          => '7',
                'dst'          => '7',
                'raw'          => '7',
            ),
            53  => array(
                'id'           => '54',
                'country_code' => 'CY',
                'time_zone_id' => 'Asia/Nicosia',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            54  => array(
                'id'           => '55',
                'country_code' => 'CZ',
                'time_zone_id' => 'Europe/Prague',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            55  => array(
                'id'           => '56',
                'country_code' => 'DE',
                'time_zone_id' => 'Europe/Berlin',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            56  => array(
                'id'           => '57',
                'country_code' => 'DJ',
                'time_zone_id' => 'Africa/Djibouti',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            57  => array(
                'id'           => '58',
                'country_code' => 'DK',
                'time_zone_id' => 'Europe/Copenhagen',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            58  => array(
                'id'           => '59',
                'country_code' => 'DM',
                'time_zone_id' => 'America/Dominica',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            59  => array(
                'id'           => '60',
                'country_code' => 'DO',
                'time_zone_id' => 'America/Santo_Domingo',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            60  => array(
                'id'           => '61',
                'country_code' => 'DZ',
                'time_zone_id' => 'Africa/Algiers',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            61  => array(
                'id'           => '62',
                'country_code' => 'EC',
                'time_zone_id' => 'America/Guayaquil',
                'gmt'          => '-5',
                'dst'          => '-5',
                'raw'          => '-5',
            ),
            62  => array(
                'id'           => '63',
                'country_code' => 'EE',
                'time_zone_id' => 'Europe/Tallinn',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            63  => array(
                'id'           => '64',
                'country_code' => 'EG',
                'time_zone_id' => 'Africa/Cairo',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
            64  => array(
                'id'           => '65',
                'country_code' => 'EH',
                'time_zone_id' => 'Africa/El_Aaiun',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            65  => array(
                'id'           => '66',
                'country_code' => 'ER',
                'time_zone_id' => 'Africa/Asmara',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            66  => array(
                'id'           => '67',
                'country_code' => 'ES',
                'time_zone_id' => 'Africa/Ceuta',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            67  => array(
                'id'           => '68',
                'country_code' => 'ET',
                'time_zone_id' => 'Africa/Addis_Ababa',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            68  => array(
                'id'           => '69',
                'country_code' => 'FI',
                'time_zone_id' => 'Europe/Helsinki',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            69  => array(
                'id'           => '70',
                'country_code' => 'FJ',
                'time_zone_id' => 'Pacific/Fiji',
                'gmt'          => '13',
                'dst'          => '12',
                'raw'          => '12',
            ),
            70  => array(
                'id'           => '71',
                'country_code' => 'FK',
                'time_zone_id' => 'Atlantic/Stanley',
                'gmt'          => '-3',
                'dst'          => '-3',
                'raw'          => '-3',
            ),
            71  => array(
                'id'           => '72',
                'country_code' => 'FM',
                'time_zone_id' => 'Pacific/Chuuk',
                'gmt'          => '10',
                'dst'          => '10',
                'raw'          => '10',
            ),
            72  => array(
                'id'           => '73',
                'country_code' => 'FO',
                'time_zone_id' => 'Atlantic/Faroe',
                'gmt'          => '0',
                'dst'          => '1',
                'raw'          => '0',
            ),
            73  => array(
                'id'           => '74',
                'country_code' => 'FR',
                'time_zone_id' => 'Europe/Paris',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            74  => array(
                'id'           => '75',
                'country_code' => 'GA',
                'time_zone_id' => 'Africa/Libreville',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            75  => array(
                'id'           => '76',
                'country_code' => 'GD',
                'time_zone_id' => 'America/Grenada',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            76  => array(
                'id'           => '77',
                'country_code' => 'GE',
                'time_zone_id' => 'Asia/Tbilisi',
                'gmt'          => '4',
                'dst'          => '4',
                'raw'          => '4',
            ),
            77  => array(
                'id'           => '78',
                'country_code' => 'GF',
                'time_zone_id' => 'America/Cayenne',
                'gmt'          => '-3',
                'dst'          => '-3',
                'raw'          => '-3',
            ),
            78  => array(
                'id'           => '79',
                'country_code' => 'GG',
                'time_zone_id' => 'Europe/Guernsey',
                'gmt'          => '0',
                'dst'          => '1',
                'raw'          => '0',
            ),
            79  => array(
                'id'           => '80',
                'country_code' => 'GH',
                'time_zone_id' => 'Africa/Accra',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            80  => array(
                'id'           => '81',
                'country_code' => 'GI',
                'time_zone_id' => 'Europe/Gibraltar',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            81  => array(
                'id'           => '82',
                'country_code' => 'GL',
                'time_zone_id' => 'America/Danmarkshavn',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            82  => array(
                'id'           => '83',
                'country_code' => 'GM',
                'time_zone_id' => 'Africa/Banjul',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            83  => array(
                'id'           => '84',
                'country_code' => 'GN',
                'time_zone_id' => 'Africa/Conakry',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            84  => array(
                'id'           => '85',
                'country_code' => 'GP',
                'time_zone_id' => 'America/Guadeloupe',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            85  => array(
                'id'           => '86',
                'country_code' => 'GQ',
                'time_zone_id' => 'Africa/Malabo',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            86  => array(
                'id'           => '87',
                'country_code' => 'GR',
                'time_zone_id' => 'Europe/Athens',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            87  => array(
                'id'           => '88',
                'country_code' => 'GS',
                'time_zone_id' => 'Atlantic/South_Georgia',
                'gmt'          => '-2',
                'dst'          => '-2',
                'raw'          => '-2',
            ),
            88  => array(
                'id'           => '89',
                'country_code' => 'GT',
                'time_zone_id' => 'America/Guatemala',
                'gmt'          => '-6',
                'dst'          => '-6',
                'raw'          => '-6',
            ),
            89  => array(
                'id'           => '90',
                'country_code' => 'GU',
                'time_zone_id' => 'Pacific/Guam',
                'gmt'          => '10',
                'dst'          => '10',
                'raw'          => '10',
            ),
            90  => array(
                'id'           => '91',
                'country_code' => 'GW',
                'time_zone_id' => 'Africa/Bissau',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            91  => array(
                'id'           => '92',
                'country_code' => 'GY',
                'time_zone_id' => 'America/Guyana',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            92  => array(
                'id'           => '93',
                'country_code' => 'HK',
                'time_zone_id' => 'Asia/Hong_Kong',
                'gmt'          => '8',
                'dst'          => '8',
                'raw'          => '8',
            ),
            93  => array(
                'id'           => '94',
                'country_code' => 'HN',
                'time_zone_id' => 'America/Tegucigalpa',
                'gmt'          => '-6',
                'dst'          => '-6',
                'raw'          => '-6',
            ),
            94  => array(
                'id'           => '95',
                'country_code' => 'HR',
                'time_zone_id' => 'Europe/Zagreb',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            95  => array(
                'id'           => '96',
                'country_code' => 'HT',
                'time_zone_id' => 'America/Port-au-Prince',
                'gmt'          => '-5',
                'dst'          => '-4',
                'raw'          => '-5',
            ),
            96  => array(
                'id'           => '97',
                'country_code' => 'HU',
                'time_zone_id' => 'Europe/Budapest',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            97  => array(
                'id'           => '98',
                'country_code' => 'ID',
                'time_zone_id' => 'Asia/Jakarta',
                'gmt'          => '7',
                'dst'          => '7',
                'raw'          => '7',
            ),
            98  => array(
                'id'           => '99',
                'country_code' => 'IE',
                'time_zone_id' => 'Europe/Dublin',
                'gmt'          => '0',
                'dst'          => '1',
                'raw'          => '0',
            ),
            99  => array(
                'id'           => '100',
                'country_code' => 'IL',
                'time_zone_id' => 'Asia/Jerusalem',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            100 => array(
                'id'           => '101',
                'country_code' => 'IM',
                'time_zone_id' => 'Europe/Isle_of_Man',
                'gmt'          => '0',
                'dst'          => '1',
                'raw'          => '0',
            ),
            101 => array(
                'id'           => '102',
                'country_code' => 'IN',
                'time_zone_id' => 'Asia/Kolkata',
                'gmt'          => '5.5',
                'dst'          => '5.5',
                'raw'          => '5.5',
            ),
            102 => array(
                'id'           => '103',
                'country_code' => 'IO',
                'time_zone_id' => 'Indian/Chagos',
                'gmt'          => '6',
                'dst'          => '6',
                'raw'          => '6',
            ),
            103 => array(
                'id'           => '104',
                'country_code' => 'IQ',
                'time_zone_id' => 'Asia/Baghdad',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            104 => array(
                'id'           => '105',
                'country_code' => 'IR',
                'time_zone_id' => 'Asia/Tehran',
                'gmt'          => '3.5',
                'dst'          => '4.5',
                'raw'          => '3.5',
            ),
            105 => array(
                'id'           => '106',
                'country_code' => 'IS',
                'time_zone_id' => 'Atlantic/Reykjavik',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            106 => array(
                'id'           => '107',
                'country_code' => 'IT',
                'time_zone_id' => 'Europe/Rome',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            107 => array(
                'id'           => '108',
                'country_code' => 'JE',
                'time_zone_id' => 'Europe/Jersey',
                'gmt'          => '0',
                'dst'          => '1',
                'raw'          => '0',
            ),
            108 => array(
                'id'           => '109',
                'country_code' => 'JM',
                'time_zone_id' => 'America/Jamaica',
                'gmt'          => '-5',
                'dst'          => '-5',
                'raw'          => '-5',
            ),
            109 => array(
                'id'           => '110',
                'country_code' => 'JO',
                'time_zone_id' => 'Asia/Amman',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            110 => array(
                'id'           => '111',
                'country_code' => 'JP',
                'time_zone_id' => 'Asia/Tokyo',
                'gmt'          => '9',
                'dst'          => '9',
                'raw'          => '9',
            ),
            111 => array(
                'id'           => '112',
                'country_code' => 'KE',
                'time_zone_id' => 'Africa/Nairobi',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            112 => array(
                'id'           => '113',
                'country_code' => 'KG',
                'time_zone_id' => 'Asia/Bishkek',
                'gmt'          => '6',
                'dst'          => '6',
                'raw'          => '6',
            ),
            113 => array(
                'id'           => '114',
                'country_code' => 'KH',
                'time_zone_id' => 'Asia/Phnom_Penh',
                'gmt'          => '7',
                'dst'          => '7',
                'raw'          => '7',
            ),
            114 => array(
                'id'           => '115',
                'country_code' => 'KI',
                'time_zone_id' => 'Pacific/Enderbury',
                'gmt'          => '13',
                'dst'          => '13',
                'raw'          => '13',
            ),
            115 => array(
                'id'           => '116',
                'country_code' => 'KM',
                'time_zone_id' => 'Indian/Comoro',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            116 => array(
                'id'           => '117',
                'country_code' => 'KN',
                'time_zone_id' => 'America/St_Kitts',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            117 => array(
                'id'           => '118',
                'country_code' => 'KP',
                'time_zone_id' => 'Asia/Pyongyang',
                'gmt'          => '9',
                'dst'          => '9',
                'raw'          => '9',
            ),
            118 => array(
                'id'           => '119',
                'country_code' => 'KR',
                'time_zone_id' => 'Asia/Seoul',
                'gmt'          => '9',
                'dst'          => '9',
                'raw'          => '9',
            ),
            119 => array(
                'id'           => '120',
                'country_code' => 'KW',
                'time_zone_id' => 'Asia/Kuwait',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            120 => array(
                'id'           => '121',
                'country_code' => 'KY',
                'time_zone_id' => 'America/Cayman',
                'gmt'          => '-5',
                'dst'          => '-5',
                'raw'          => '-5',
            ),
            121 => array(
                'id'           => '122',
                'country_code' => 'KZ',
                'time_zone_id' => 'Asia/Almaty',
                'gmt'          => '6',
                'dst'          => '6',
                'raw'          => '6',
            ),
            122 => array(
                'id'           => '123',
                'country_code' => 'LA',
                'time_zone_id' => 'Asia/Vientiane',
                'gmt'          => '7',
                'dst'          => '7',
                'raw'          => '7',
            ),
            123 => array(
                'id'           => '124',
                'country_code' => 'LB',
                'time_zone_id' => 'Asia/Beirut',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            124 => array(
                'id'           => '125',
                'country_code' => 'LC',
                'time_zone_id' => 'America/St_Lucia',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            125 => array(
                'id'           => '126',
                'country_code' => 'LI',
                'time_zone_id' => 'Europe/Vaduz',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            126 => array(
                'id'           => '127',
                'country_code' => 'LK',
                'time_zone_id' => 'Asia/Colombo',
                'gmt'          => '5.5',
                'dst'          => '5.5',
                'raw'          => '5.5',
            ),
            127 => array(
                'id'           => '128',
                'country_code' => 'LR',
                'time_zone_id' => 'Africa/Monrovia',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            128 => array(
                'id'           => '129',
                'country_code' => 'LS',
                'time_zone_id' => 'Africa/Maseru',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
            129 => array(
                'id'           => '130',
                'country_code' => 'LT',
                'time_zone_id' => 'Europe/Vilnius',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            130 => array(
                'id'           => '131',
                'country_code' => 'LU',
                'time_zone_id' => 'Europe/Luxembourg',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            131 => array(
                'id'           => '132',
                'country_code' => 'LV',
                'time_zone_id' => 'Europe/Riga',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            132 => array(
                'id'           => '133',
                'country_code' => 'LY',
                'time_zone_id' => 'Africa/Tripoli',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
            133 => array(
                'id'           => '134',
                'country_code' => 'MA',
                'time_zone_id' => 'Africa/Casablanca',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            134 => array(
                'id'           => '135',
                'country_code' => 'MC',
                'time_zone_id' => 'Europe/Monaco',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            135 => array(
                'id'           => '136',
                'country_code' => 'MD',
                'time_zone_id' => 'Europe/Chisinau',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            136 => array(
                'id'           => '137',
                'country_code' => 'ME',
                'time_zone_id' => 'Europe/Podgorica',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            137 => array(
                'id'           => '138',
                'country_code' => 'MF',
                'time_zone_id' => 'America/Marigot',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            138 => array(
                'id'           => '139',
                'country_code' => 'MG',
                'time_zone_id' => 'Indian/Antananarivo',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            139 => array(
                'id'           => '140',
                'country_code' => 'MH',
                'time_zone_id' => 'Pacific/Kwajalein',
                'gmt'          => '12',
                'dst'          => '12',
                'raw'          => '12',
            ),
            140 => array(
                'id'           => '141',
                'country_code' => 'MK',
                'time_zone_id' => 'Europe/Skopje',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            141 => array(
                'id'           => '142',
                'country_code' => 'ML',
                'time_zone_id' => 'Africa/Bamako',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            142 => array(
                'id'           => '143',
                'country_code' => 'MM',
                'time_zone_id' => 'Asia/Rangoon',
                'gmt'          => '6.5',
                'dst'          => '6.5',
                'raw'          => '6.5',
            ),
            143 => array(
                'id'           => '144',
                'country_code' => 'MN',
                'time_zone_id' => 'Asia/Choibalsan',
                'gmt'          => '8',
                'dst'          => '8',
                'raw'          => '8',
            ),
            144 => array(
                'id'           => '145',
                'country_code' => 'MO',
                'time_zone_id' => 'Asia/Macau',
                'gmt'          => '8',
                'dst'          => '8',
                'raw'          => '8',
            ),
            145 => array(
                'id'           => '146',
                'country_code' => 'MP',
                'time_zone_id' => 'Pacific/Saipan',
                'gmt'          => '10',
                'dst'          => '10',
                'raw'          => '10',
            ),
            146 => array(
                'id'           => '147',
                'country_code' => 'MQ',
                'time_zone_id' => 'America/Martinique',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            147 => array(
                'id'           => '148',
                'country_code' => 'MR',
                'time_zone_id' => 'Africa/Nouakchott',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            148 => array(
                'id'           => '149',
                'country_code' => 'MS',
                'time_zone_id' => 'America/Montserrat',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            149 => array(
                'id'           => '150',
                'country_code' => 'MT',
                'time_zone_id' => 'Europe/Malta',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            150 => array(
                'id'           => '151',
                'country_code' => 'MU',
                'time_zone_id' => 'Indian/Mauritius',
                'gmt'          => '4',
                'dst'          => '4',
                'raw'          => '4',
            ),
            151 => array(
                'id'           => '152',
                'country_code' => 'MV',
                'time_zone_id' => 'Indian/Maldives',
                'gmt'          => '5',
                'dst'          => '5',
                'raw'          => '5',
            ),
            152 => array(
                'id'           => '153',
                'country_code' => 'MW',
                'time_zone_id' => 'Africa/Blantyre',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
            153 => array(
                'id'           => '154',
                'country_code' => 'MX',
                'time_zone_id' => 'America/Bahia_Banderas',
                'gmt'          => '-6',
                'dst'          => '-5',
                'raw'          => '-6',
            ),
            154 => array(
                'id'           => '155',
                'country_code' => 'MY',
                'time_zone_id' => 'Asia/Kuala_Lumpur',
                'gmt'          => '8',
                'dst'          => '8',
                'raw'          => '8',
            ),
            155 => array(
                'id'           => '156',
                'country_code' => 'MZ',
                'time_zone_id' => 'Africa/Maputo',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
            156 => array(
                'id'           => '157',
                'country_code' => 'NA',
                'time_zone_id' => 'Africa/Windhoek',
                'gmt'          => '2',
                'dst'          => '1',
                'raw'          => '1',
            ),
            157 => array(
                'id'           => '158',
                'country_code' => 'NC',
                'time_zone_id' => 'Pacific/Noumea',
                'gmt'          => '11',
                'dst'          => '11',
                'raw'          => '11',
            ),
            158 => array(
                'id'           => '159',
                'country_code' => 'NE',
                'time_zone_id' => 'Africa/Niamey',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            159 => array(
                'id'           => '160',
                'country_code' => 'NF',
                'time_zone_id' => 'Pacific/Norfolk',
                'gmt'          => '11.5',
                'dst'          => '11.5',
                'raw'          => '11.5',
            ),
            160 => array(
                'id'           => '161',
                'country_code' => 'NG',
                'time_zone_id' => 'Africa/Lagos',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            161 => array(
                'id'           => '162',
                'country_code' => 'NI',
                'time_zone_id' => 'America/Managua',
                'gmt'          => '-6',
                'dst'          => '-6',
                'raw'          => '-6',
            ),
            162 => array(
                'id'           => '163',
                'country_code' => 'NL',
                'time_zone_id' => 'Europe/Amsterdam',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            163 => array(
                'id'           => '164',
                'country_code' => 'NO',
                'time_zone_id' => 'Europe/Oslo',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            164 => array(
                'id'           => '165',
                'country_code' => 'NP',
                'time_zone_id' => 'Asia/Kathmandu',
                'gmt'          => '5.75',
                'dst'          => '5.75',
                'raw'          => '5.75',
            ),
            165 => array(
                'id'           => '166',
                'country_code' => 'NR',
                'time_zone_id' => 'Pacific/Nauru',
                'gmt'          => '12',
                'dst'          => '12',
                'raw'          => '12',
            ),
            166 => array(
                'id'           => '167',
                'country_code' => 'NU',
                'time_zone_id' => 'Pacific/Niue',
                'gmt'          => '-11',
                'dst'          => '-11',
                'raw'          => '-11',
            ),
            167 => array(
                'id'           => '168',
                'country_code' => 'NZ',
                'time_zone_id' => 'Pacific/Auckland',
                'gmt'          => '13',
                'dst'          => '12',
                'raw'          => '12',
            ),
            168 => array(
                'id'           => '169',
                'country_code' => 'OM',
                'time_zone_id' => 'Asia/Muscat',
                'gmt'          => '4',
                'dst'          => '4',
                'raw'          => '4',
            ),
            169 => array(
                'id'           => '170',
                'country_code' => 'PA',
                'time_zone_id' => 'America/Panama',
                'gmt'          => '-5',
                'dst'          => '-5',
                'raw'          => '-5',
            ),
            170 => array(
                'id'           => '171',
                'country_code' => 'PE',
                'time_zone_id' => 'America/Lima',
                'gmt'          => '-5',
                'dst'          => '-5',
                'raw'          => '-5',
            ),
            171 => array(
                'id'           => '172',
                'country_code' => 'PF',
                'time_zone_id' => 'Pacific/Gambier',
                'gmt'          => '-9',
                'dst'          => '-9',
                'raw'          => '-9',
            ),
            172 => array(
                'id'           => '173',
                'country_code' => 'PG',
                'time_zone_id' => 'Pacific/Bougainville',
                'gmt'          => '11',
                'dst'          => '11',
                'raw'          => '11',
            ),
            173 => array(
                'id'           => '174',
                'country_code' => 'PH',
                'time_zone_id' => 'Asia/Manila',
                'gmt'          => '8',
                'dst'          => '8',
                'raw'          => '8',
            ),
            174 => array(
                'id'           => '175',
                'country_code' => 'PK',
                'time_zone_id' => 'Asia/Karachi',
                'gmt'          => '5',
                'dst'          => '5',
                'raw'          => '5',
            ),
            175 => array(
                'id'           => '176',
                'country_code' => 'PL',
                'time_zone_id' => 'Europe/Warsaw',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            176 => array(
                'id'           => '177',
                'country_code' => 'PM',
                'time_zone_id' => 'America/Miquelon',
                'gmt'          => '-3',
                'dst'          => '-2',
                'raw'          => '-3',
            ),
            177 => array(
                'id'           => '178',
                'country_code' => 'PN',
                'time_zone_id' => 'Pacific/Pitcairn',
                'gmt'          => '-8',
                'dst'          => '-8',
                'raw'          => '-8',
            ),
            178 => array(
                'id'           => '179',
                'country_code' => 'PR',
                'time_zone_id' => 'America/Puerto_Rico',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            179 => array(
                'id'           => '180',
                'country_code' => 'PS',
                'time_zone_id' => 'Asia/Gaza',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            180 => array(
                'id'           => '181',
                'country_code' => 'PT',
                'time_zone_id' => 'Atlantic/Azores',
                'gmt'          => '-1',
                'dst'          => '0',
                'raw'          => '-1',
            ),
            181 => array(
                'id'           => '182',
                'country_code' => 'PW',
                'time_zone_id' => 'Pacific/Palau',
                'gmt'          => '9',
                'dst'          => '9',
                'raw'          => '9',
            ),
            182 => array(
                'id'           => '183',
                'country_code' => 'PY',
                'time_zone_id' => 'America/Asuncion',
                'gmt'          => '-3',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            183 => array(
                'id'           => '184',
                'country_code' => 'QA',
                'time_zone_id' => 'Asia/Qatar',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            184 => array(
                'id'           => '185',
                'country_code' => 'RE',
                'time_zone_id' => 'Indian/Reunion',
                'gmt'          => '4',
                'dst'          => '4',
                'raw'          => '4',
            ),
            185 => array(
                'id'           => '186',
                'country_code' => 'RO',
                'time_zone_id' => 'Europe/Bucharest',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            186 => array(
                'id'           => '187',
                'country_code' => 'RS',
                'time_zone_id' => 'Europe/Belgrade',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            187 => array(
                'id'           => '188',
                'country_code' => 'RU',
                'time_zone_id' => 'Asia/Anadyr',
                'gmt'          => '12',
                'dst'          => '12',
                'raw'          => '12',
            ),
            188 => array(
                'id'           => '189',
                'country_code' => 'RW',
                'time_zone_id' => 'Africa/Kigali',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
            189 => array(
                'id'           => '190',
                'country_code' => 'SA',
                'time_zone_id' => 'Asia/Riyadh',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            190 => array(
                'id'           => '191',
                'country_code' => 'SB',
                'time_zone_id' => 'Pacific/Guadalcanal',
                'gmt'          => '11',
                'dst'          => '11',
                'raw'          => '11',
            ),
            191 => array(
                'id'           => '192',
                'country_code' => 'SC',
                'time_zone_id' => 'Indian/Mahe',
                'gmt'          => '4',
                'dst'          => '4',
                'raw'          => '4',
            ),
            192 => array(
                'id'           => '193',
                'country_code' => 'SD',
                'time_zone_id' => 'Africa/Khartoum',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            193 => array(
                'id'           => '194',
                'country_code' => 'SE',
                'time_zone_id' => 'Europe/Stockholm',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            194 => array(
                'id'           => '195',
                'country_code' => 'SG',
                'time_zone_id' => 'Asia/Singapore',
                'gmt'          => '8',
                'dst'          => '8',
                'raw'          => '8',
            ),
            195 => array(
                'id'           => '196',
                'country_code' => 'SH',
                'time_zone_id' => 'Atlantic/St_Helena',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            196 => array(
                'id'           => '197',
                'country_code' => 'SI',
                'time_zone_id' => 'Europe/Ljubljana',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            197 => array(
                'id'           => '198',
                'country_code' => 'SJ',
                'time_zone_id' => 'Arctic/Longyearbyen',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            198 => array(
                'id'           => '199',
                'country_code' => 'SK',
                'time_zone_id' => 'Europe/Bratislava',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            199 => array(
                'id'           => '200',
                'country_code' => 'SL',
                'time_zone_id' => 'Africa/Freetown',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            200 => array(
                'id'           => '201',
                'country_code' => 'SM',
                'time_zone_id' => 'Europe/San_Marino',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            201 => array(
                'id'           => '202',
                'country_code' => 'SN',
                'time_zone_id' => 'Africa/Dakar',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            202 => array(
                'id'           => '203',
                'country_code' => 'SO',
                'time_zone_id' => 'Africa/Mogadishu',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            203 => array(
                'id'           => '204',
                'country_code' => 'SR',
                'time_zone_id' => 'America/Paramaribo',
                'gmt'          => '-3',
                'dst'          => '-3',
                'raw'          => '-3',
            ),
            204 => array(
                'id'           => '205',
                'country_code' => 'SS',
                'time_zone_id' => 'Africa/Juba',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            205 => array(
                'id'           => '206',
                'country_code' => 'ST',
                'time_zone_id' => 'Africa/Sao_Tome',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            206 => array(
                'id'           => '207',
                'country_code' => 'SV',
                'time_zone_id' => 'America/El_Salvador',
                'gmt'          => '-6',
                'dst'          => '-6',
                'raw'          => '-6',
            ),
            207 => array(
                'id'           => '208',
                'country_code' => 'SX',
                'time_zone_id' => 'America/Lower_Princes',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            208 => array(
                'id'           => '209',
                'country_code' => 'SY',
                'time_zone_id' => 'Asia/Damascus',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            209 => array(
                'id'           => '210',
                'country_code' => 'SZ',
                'time_zone_id' => 'Africa/Mbabane',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
            210 => array(
                'id'           => '211',
                'country_code' => 'TC',
                'time_zone_id' => 'America/Grand_Turk',
                'gmt'          => '-5',
                'dst'          => '-4',
                'raw'          => '-5',
            ),
            211 => array(
                'id'           => '212',
                'country_code' => 'TD',
                'time_zone_id' => 'Africa/Ndjamena',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            212 => array(
                'id'           => '213',
                'country_code' => 'TF',
                'time_zone_id' => 'Indian/Kerguelen',
                'gmt'          => '5',
                'dst'          => '5',
                'raw'          => '5',
            ),
            213 => array(
                'id'           => '214',
                'country_code' => 'TG',
                'time_zone_id' => 'Africa/Lome',
                'gmt'          => '0',
                'dst'          => '0',
                'raw'          => '0',
            ),
            214 => array(
                'id'           => '215',
                'country_code' => 'TH',
                'time_zone_id' => 'Asia/Bangkok',
                'gmt'          => '7',
                'dst'          => '7',
                'raw'          => '7',
            ),
            215 => array(
                'id'           => '216',
                'country_code' => 'TJ',
                'time_zone_id' => 'Asia/Dushanbe',
                'gmt'          => '5',
                'dst'          => '5',
                'raw'          => '5',
            ),
            216 => array(
                'id'           => '217',
                'country_code' => 'TK',
                'time_zone_id' => 'Pacific/Fakaofo',
                'gmt'          => '13',
                'dst'          => '13',
                'raw'          => '13',
            ),
            217 => array(
                'id'           => '218',
                'country_code' => 'TL',
                'time_zone_id' => 'Asia/Dili',
                'gmt'          => '9',
                'dst'          => '9',
                'raw'          => '9',
            ),
            218 => array(
                'id'           => '219',
                'country_code' => 'TM',
                'time_zone_id' => 'Asia/Ashgabat',
                'gmt'          => '5',
                'dst'          => '5',
                'raw'          => '5',
            ),
            219 => array(
                'id'           => '220',
                'country_code' => 'TN',
                'time_zone_id' => 'Africa/Tunis',
                'gmt'          => '1',
                'dst'          => '1',
                'raw'          => '1',
            ),
            220 => array(
                'id'           => '221',
                'country_code' => 'TO',
                'time_zone_id' => 'Pacific/Tongatapu',
                'gmt'          => '13',
                'dst'          => '13',
                'raw'          => '13',
            ),
            221 => array(
                'id'           => '222',
                'country_code' => 'TR',
                'time_zone_id' => 'Europe/Istanbul',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            222 => array(
                'id'           => '223',
                'country_code' => 'TT',
                'time_zone_id' => 'America/Port_of_Spain',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            223 => array(
                'id'           => '224',
                'country_code' => 'TV',
                'time_zone_id' => 'Pacific/Funafuti',
                'gmt'          => '12',
                'dst'          => '12',
                'raw'          => '12',
            ),
            224 => array(
                'id'           => '225',
                'country_code' => 'TW',
                'time_zone_id' => 'Asia/Taipei',
                'gmt'          => '8',
                'dst'          => '8',
                'raw'          => '8',
            ),
            225 => array(
                'id'           => '226',
                'country_code' => 'TZ',
                'time_zone_id' => 'Africa/Dar_es_Salaam',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            226 => array(
                'id'           => '227',
                'country_code' => 'UA',
                'time_zone_id' => 'Europe/Kiev',
                'gmt'          => '2',
                'dst'          => '3',
                'raw'          => '2',
            ),
            227 => array(
                'id'           => '228',
                'country_code' => 'UG',
                'time_zone_id' => 'Africa/Kampala',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            228 => array(
                'id'           => '229',
                'country_code' => 'UK',
                'time_zone_id' => 'Europe/London',
                'gmt'          => '0',
                'dst'          => '1',
                'raw'          => '0',
            ),
            229 => array(
                'id'           => '230',
                'country_code' => 'UM',
                'time_zone_id' => 'Pacific/Johnston',
                'gmt'          => '-10',
                'dst'          => '-10',
                'raw'          => '-10',
            ),
            230 => array(
                'id'           => '231',
                'country_code' => 'US',
                'time_zone_id' => 'America/Adak',
                'gmt'          => '-10',
                'dst'          => '-9',
                'raw'          => '-10',
            ),
            231 => array(
                'id'           => '232',
                'country_code' => 'UY',
                'time_zone_id' => 'America/Montevideo',
                'gmt'          => '-2',
                'dst'          => '-3',
                'raw'          => '-3',
            ),
            232 => array(
                'id'           => '233',
                'country_code' => 'UZ',
                'time_zone_id' => 'Asia/Samarkand',
                'gmt'          => '5',
                'dst'          => '5',
                'raw'          => '5',
            ),
            233 => array(
                'id'           => '234',
                'country_code' => 'VA',
                'time_zone_id' => 'Europe/Vatican',
                'gmt'          => '1',
                'dst'          => '2',
                'raw'          => '1',
            ),
            234 => array(
                'id'           => '235',
                'country_code' => 'VC',
                'time_zone_id' => 'America/St_Vincent',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            235 => array(
                'id'           => '236',
                'country_code' => 'VE',
                'time_zone_id' => 'America/Caracas',
                'gmt'          => '-4.5',
                'dst'          => '-4.5',
                'raw'          => '-4.5',
            ),
            236 => array(
                'id'           => '237',
                'country_code' => 'VG',
                'time_zone_id' => 'America/Tortola',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            237 => array(
                'id'           => '238',
                'country_code' => 'VI',
                'time_zone_id' => 'America/St_Thomas',
                'gmt'          => '-4',
                'dst'          => '-4',
                'raw'          => '-4',
            ),
            238 => array(
                'id'           => '239',
                'country_code' => 'VN',
                'time_zone_id' => 'Asia/Ho_Chi_Minh',
                'gmt'          => '7',
                'dst'          => '7',
                'raw'          => '7',
            ),
            239 => array(
                'id'           => '240',
                'country_code' => 'VU',
                'time_zone_id' => 'Pacific/Efate',
                'gmt'          => '11',
                'dst'          => '11',
                'raw'          => '11',
            ),
            240 => array(
                'id'           => '241',
                'country_code' => 'WF',
                'time_zone_id' => 'Pacific/Wallis',
                'gmt'          => '12',
                'dst'          => '12',
                'raw'          => '12',
            ),
            241 => array(
                'id'           => '242',
                'country_code' => 'WS',
                'time_zone_id' => 'Pacific/Apia',
                'gmt'          => '14',
                'dst'          => '13',
                'raw'          => '13',
            ),
            242 => array(
                'id'           => '243',
                'country_code' => 'YE',
                'time_zone_id' => 'Asia/Aden',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            243 => array(
                'id'           => '244',
                'country_code' => 'YT',
                'time_zone_id' => 'Indian/Mayotte',
                'gmt'          => '3',
                'dst'          => '3',
                'raw'          => '3',
            ),
            244 => array(
                'id'           => '245',
                'country_code' => 'ZA',
                'time_zone_id' => 'Africa/Johannesburg',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
            245 => array(
                'id'           => '246',
                'country_code' => 'ZM',
                'time_zone_id' => 'Africa/Lusaka',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
            246 => array(
                'id'           => '247',
                'country_code' => 'ZW',
                'time_zone_id' => 'Africa/Harare',
                'gmt'          => '2',
                'dst'          => '2',
                'raw'          => '2',
            ),
        ));
    }
}
