<?php
/**
 * LaraClassified - Geo Classified Ads CMS
 * Copyright (c) Mayeul Akpovi. All Rights Reserved
 *
 * Email: mayeul.a@larapen.com
 * Website: http://larapen.com
 *
 * LICENSE
 * -------
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the inclusion
 * of the above copyright notice. If you Purchased from Codecanyon,
 * Please read the full License from here - http://codecanyon.net/licenses/standard
 */

namespace Larapen\Settings\app\Models;

use Illuminate\Database\Eloquent\Model;
use Larapen\CRUD\CrudTrait;
use Illuminate\Support\Facades\Request;

class Setting extends Model
{
    use CrudTrait;
    
    protected $table = 'settings';
    protected $guarded = ['id'];
    protected $fillable = ['value', 'lft', 'rgt', 'depth'];
    
    public function getLogoHtml()
    {
        if ($this->key == 'app_logo') {
            if ($this->value == '') {
                $logo = 'images/logo.png';
            } else {
                $logoFilename = last(explode('/', $this->value));
                $logo = 'pic/x/cache/logo/' . $logoFilename;
            }
            
            return '<img src="' . url($logo) . '" alt="' . $this->value . '"><br>[<a href="/admin/setting/' . $this->id . '/edit">Edit</a>]';
        } else {
            return $this->value;
        }
    }
    
    public function getValueAttribute($value)
    {
        if (Request::segment(1) == 'admin') {
            $hiddenValues = [
                'recaptcha_private_key',
                'services_mailgun_secret',
                'services_ses_key',
                'services_ses_secret',
                'mail_password',
                'paypal_password',
                'paypal_signature',
                'services_facebook_client_secret',
                'services_google_client_secret',
                'services_google_api_key'
            ];
            
            if (in_array($this->attributes['key'], $hiddenValues)) {
                $value = '************************';
            } else {
                if (str_contains($this->attributes['field'], 'checkbox')) {
                    if (Request::segment(4) != 'edit') {
                        if ($value == 1) {
                            $value = '<i class="fa fa-check-square-o" aria-hidden="true"></i>';
                        } else {
                            $value = '<i class="fa fa-square-o" aria-hidden="true"></i>';
                        }
                    }
                }
            }
            
            return $value;
        } else {
            return $value;
        }
    }
}
