<?php
/**
 * LaraClassified - Geo Classified Ads CMS
 * Copyright (c) Mayeul Akpovi. All Rights Reserved
 *
 * Email: mayeul.a@larapen.com
 * Website: http://larapen.com
 *
 * LICENSE
 * -------
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the inclusion
 * of the above copyright notice. If you Purchased from Codecanyon,
 * Please read the full License from here - http://codecanyon.net/licenses/standard
 */

namespace Larapen\LaravelLocalization;

use App\Larapen\Models\Category;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\LaravelLocalization as McamaraLaravelLocalization;
use Mcamara\LaravelLocalization\Exceptions\SupportedLocalesNotDefined;
use Mcamara\LaravelLocalization\Exceptions\UnsupportedLocaleException;
use Illuminate\Config\Repository;
use Illuminate\View\Factory;
use Illuminate\Translation\Translator;
use Illuminate\Routing\Router;
use Illuminate\Http\Request;
use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\URL;

class LaravelLocalization extends McamaraLaravelLocalization
{
    /**
     * Creates new instance.
     * @throws UnsupportedLocaleException
     */
    public function __construct()
    {
        parent::__construct();
    }
    
    /**
     * Returns an URL adapted to $locale
     *
     * @throws SupportedLocalesNotDefined
     * @throws UnsupportedLocaleException
     *
     * @param  string|boolean $locale Locale to adapt, false to remove locale
     * @param  string|false $url URL to adapt in the current language. If not passed, the current url would be taken.
     * @param  array $attributes Attributes to add to the route, if empty, the system would try to extract them from the url.
     *
     *
     * @return string|false                URL translated, False if url does not exist
     */
    public function getLocalizedURL($locale = null, $url = null, $attributes = array())
    {
        if ($locale === null) {
            $locale = $this->getCurrentLocale();
        }
        
        // Edit by Mayeul Akpovi
        if ($this->exceptRedirectionPath()) {
            return false;
        }
        
        // Edit by Mayeul Akpovi
        if (!$this->checkLocaleInSupportedLocales($locale)) {
            return false;
        }
        
        if (empty($attributes)) {
            $attributes = $this->extractAttributes($url);
        }
        
        if (empty($url)) {
            if (!empty($this->routeName)) {
                return $this->getURLFromRouteNameTranslated($locale, $this->routeName, $attributes);
            }
            
            // For LaraClassified
            if (str_contains(Route::currentRouteAction(), 'SearchController@category') or str_contains(Route::currentRouteAction(),
                    'SearchController@subCategory')
            ) {
                $cache_expire = (int)config('settings.app_cache_expire');
                
                // Get category or sub-category translation
                if ($this->request->segment(4) != '') {
                    $cat = $this->getCategoryBySlug($this->request->segment(4), $locale);
                }
                if ($this->request->segment(5) != '') {
                    $sub_cat = $this->getCategoryBySlug($this->request->segment(5), $locale);
                }
                
                // Build URL
                if (isset($cat) and isset($sub_cat) and !is_null($cat) and !is_null($sub_cat)) {
                    $url = $this->request->segment(1) . '/' . $this->request->segment(2) . '/' . $this->request->segment(3) . '/' . $cat->slug . '/' . $sub_cat->slug;
                } else {
                    if (isset($cat) and !is_null($cat)) {
                        $url = $this->request->segment(1) . '/' . $this->request->segment(2) . '/' . $this->request->segment(3) . '/' . $cat->slug;
                    } else {
                        $url = $this->request->fullUrl();
                    }
                }
            } else {
                $url = $this->request->fullUrl();
            }
        }
        
        if ($locale && $translatedRoute = $this->findTranslatedRouteByUrl($url, $attributes, $this->currentLocale)) {
            return $this->getURLFromRouteNameTranslated($locale, $translatedRoute, $attributes);
        }
        
        $base_path = $this->request->getBaseUrl();
        $parsed_url = mb_parse_url($url); //=> UTF-8
        $url_locale = $this->getDefaultLocale();
        
        if (!$parsed_url || empty($parsed_url['path'])) {
            $path = $parsed_url['path'] = "";
        } else {
            $parsed_url['path'] = str_replace($base_path, '', '/' . ltrim($parsed_url['path'], '/'));
            $path = $parsed_url['path'];
            foreach ($this->getSupportedLocales() as $localeCode => $lang) {
                $parsed_url['path'] = preg_replace('%^/?' . $localeCode . '/%', '$1', $parsed_url['path']);
                if ($parsed_url['path'] !== $path) {
                    $url_locale = $localeCode;
                    break;
                }
                
                $parsed_url['path'] = preg_replace('%^/?' . $localeCode . '$%', '$1', $parsed_url['path']);
                if ($parsed_url['path'] !== $path) {
                    $url_locale = $localeCode;
                    break;
                }
            }
        }
        
        $parsed_url['path'] = ltrim($parsed_url['path'], '/');
        
        if ($translatedRoute = $this->findTranslatedRouteByPath($parsed_url['path'], $url_locale)) {
            return $this->getURLFromRouteNameTranslated($locale, $translatedRoute, $attributes);
        }
        
        if (!empty($locale) && ($locale != $this->defaultLocale || !$this->hideDefaultLocaleInURL())) {
            $parsed_url['path'] = $locale . '/' . ltrim($parsed_url['path'], '/');
        }
        $parsed_url['path'] = ltrim(ltrim($base_path, '/') . '/' . $parsed_url['path'], '/');
        
        //Make sure that the pass path is returned with a leading slash only if it come in with one.
        if (starts_with($path, '/') === true) {
            $parsed_url['path'] = '/' . $parsed_url['path'];
        }
        $parsed_url['path'] = rtrim($parsed_url['path'], '/');
        
        $url = $this->unparseUrl($parsed_url);
        if ($this->checkUrl($url)) {
            return $url;
        }
        
        return $this->createUrlFromUri($url);
    }
    
    protected function getCategoryBySlug($slug, $locale)
    {
        $cat = null;
        
        if ($slug == '' or $locale == '') {
            return $cat;
        }
        
        $tmpCat = Category::where('translation_lang', config('app.locale'))->where('slug', 'LIKE', $slug)->first();
        if (!is_null($tmpCat)) {
            $cat = Category::transById($tmpCat->tid, $locale);
        }
        
        return $cat;
    }
    
    /**
     * @return bool
     */
    public function exceptRedirectionPath()
    {
        // Use url() for this paths
        if (in_array($this->request->segment(1), array(
            '_debugbar',
            'assets',
            'css',
            'js',
            'pic',
            'ajax',
            'api',
            'script',
            'tools',
            'images',
            'admin',
            'home',
        ))) {
            return true;
        }
        
        return false;
    }
}
