<?php
/**
 * LaraClassified - Geo Classified Ads CMS
 * Copyright (c) Mayeul Akpovi. All Rights Reserved
 *
 * Email: mayeul.a@larapen.com
 * Website: http://larapen.com
 *
 * LICENSE
 * -------
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the inclusion
 * of the above copyright notice. If you Purchased from Codecanyon,
 * Please read the full License from here - http://codecanyon.net/licenses/standard
 */

namespace Larapen\LaravelLocalization;

use Mcamara\LaravelLocalization\LaravelLocalizationServiceProvider as McamaraLaravelLocalizationServiceProvider;

class LaravelLocalizationServiceProvider extends McamaraLaravelLocalizationServiceProvider
{
    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $reflection = new \ReflectionClass(get_parent_class($this));
        $directory = dirname($reflection->getFileName());
        
        $packageConfigFile = $directory . '/../../config/config.php';
        
        $this->mergeConfigFrom($packageConfigFile, 'laravellocalization');
        
        $this->app['laravellocalization'] = $this->app->share(function () {
            return new LaravelLocalization();
        });
    }
}
