<?php
/**
 * LaraClassified - Geo Classified Ads CMS
 * Copyright (c) Mayeul Akpovi. All Rights Reserved
 *
 * Email: mayeul.a@larapen.com
 * Website: http://larapen.com
 *
 * LICENSE
 * -------
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the inclusion
 * of the above copyright notice. If you Purchased from Codecanyon,
 * Please read the full License from here - http://codecanyon.net/licenses/standard
 */

namespace Larapen\LaravelMetaTags;

use Torann\LaravelMetaTags\MetaTag as TorannMetaTag;
use Illuminate\Http\Request;

class MetaTag extends TorannMetaTag
{
    /**
     * @var array
     */
    public $metas = [];
    
    /**
     * @param  \Illuminate\Http\Request $request
     * @param  array $config
     * @param  string $defaultLocale
     */
    public function __construct(Request $request, array $config = [], $defaultLocale)
    {
        parent::__construct($request, $config, $defaultLocale);
    }
    
    /**
     * Create a tag based on the given key
     *
     * @param  string $key
     * @param  string $value
     * @return string
     */
    public function tag($key, $value = '')
    {
        $res = $this->createTag([
            'name' => $key,
            'content' => (isset($this->metas[$key])) ? $this->metas[$key] : $value
        ]);
        
        return $res;
    }
    
    /**
     * Create meta tag from attributes
     *
     * @param  array $values
     * @return string
     */
    private function createTag(array $values)
    {
        $attributes = array_map(function ($key) use ($values) {
            $value = $this->fix($values[$key]);
            
            return "{$key}=\"{$value}\"";
        }, array_keys($values));
        
        $attributes = implode(' ', $attributes);
        
        return "<meta {$attributes}>\n    ";
    }
    
    /**
     * @param  string $text
     * @return string
     */
    private function fix($text)
    {
        $text = preg_replace('/<[^>]+>/', ' ', $text);
        $text = preg_replace('/[\r\n\s]+/', ' ', $text);
        
        return trim(str_replace('"', '&quot;', $text));
    }
}
