{{--
 * LaraClassified - Geo Classified Ads CMS
 * Copyright (c) Mayeul Akpovi. All Rights Reserved
 *
 * Email: mayeul.a@larapen.com
 * Website: http://larapen.com
 *
 * LICENSE
 * -------
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the inclusion
 * of the above copyright notice. If you Purchased from Codecanyon,
 * Please read the full License from here - http://codecanyon.net/licenses/standard
--}}
<!DOCTYPE html>
<html lang="{{ ($lang->has('abbr')) ? $lang->get('abbr') : 'en' }}">
<head>
	<meta charset="utf-8">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	@if (isset($lang) and isset($country) and $country->has('lang'))
		@if ($lang->get('abbr') != $country->get('lang')->get('abbr'))
			<meta name="robots" content="noindex">
			<meta name="googlebot" content="noindex">
		@endif
	@endif
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="apple-mobile-web-app-title" content="{{ config('settings.app_name') }}">
	<link rel="apple-touch-icon-precomposed" sizes="144x144" href="/assets/ico/apple-touch-icon-144-precomposed.png">
	<link rel="apple-touch-icon-precomposed" sizes="114x114" href="/assets/ico/apple-touch-icon-114-precomposed.png">
	<link rel="apple-touch-icon-precomposed" sizes="72x72" href="/assets/ico/apple-touch-icon-72-precomposed.png">
	<link rel="apple-touch-icon-precomposed" href="/assets/ico/apple-touch-icon-57-precomposed.png">
	<link rel="shortcut icon" href="/assets/ico/favicon.png">
	<title>{{ MetaTag::get('title') }}</title>
	{!! MetaTag::tag('description') !!}
	<link rel="canonical" href="{{ \Illuminate\Support\Facades\URL::full() }}"/>
	@foreach(LaravelLocalization::getSupportedLocales() as $localeCode => $properties)
		@if (is_available_lang($localeCode) and strtolower($localeCode) != strtolower($lang->get('abbr')))
			<link rel="alternate" href="{{ LaravelLocalization::getLocalizedURL($localeCode) }}" hreflang="{{ strtolower($localeCode) }}"/>
		@endif
	@endforeach
	@if (count($dns_prefetch) > 0)
		@foreach($dns_prefetch as $dns)
			<link rel="dns-prefetch" href="{{ $dns }}">
		@endforeach
	@endif
	@if (config('services.facebook.client_id'))
		<meta property="fb:app_id" content="{{ config('services.facebook.client_id') }}"/>
	@endif
	{!! $og->renderTags() !!}
	{!! MetaTag::twitterCard() !!}
	@if (config('settings.google_site_verification'))
		<meta name="google-site-verification" content="{{ config('settings.google_site_verification') }}"/>
	@endif
	@if (config('settings.msvalidate'))
		<meta name="msvalidate.01" content="{{ config('settings.msvalidate') }}" />
	@endif
	@if (config('settings.alexa_verify_id'))
		<meta name="alexaVerifyID" content="{{ config('settings.alexa_verify_id') }}"/>
	@endif
	<link href="/assets/bootstrap/css/bootstrap.min.css" rel="stylesheet">
	<link href="/assets/plugins/select2/css/select2.min.css" rel="stylesheet">
	<link href="/assets/css/style.css" rel="stylesheet">
	<link href="/assets/css/style/default.css" rel="stylesheet">
	@if (config('app.theme'))
		<link href="/assets/css/style/{{ config('app.theme') }}.css" rel="stylesheet">
	@endif
	<link href="/assets/css/fileinput.min.css" media="all" rel="stylesheet" type="text/css"/>
	<link href="/assets/css/owl.carousel.css" rel="stylesheet">
	<link href="/assets/css/owl.theme.css" rel="stylesheet">
	<link href="/assets/css/flags/flags.css" rel="stylesheet">
	@section('css')
	@show
	@section('javascript-top')
	@show


	<!--[if lt IE 9]>
	<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
	<script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
	<![endif]-->

	<script>
		paceOptions = {
			elements: true
		};
	</script>
	<script src="/assets/js/pace.min.js"></script>
</head>
<body>

<div id="wrapper">

	@section('header')
		@if (Auth::check())
			@include('classified/layouts/inc/header', ['user' => $user])
		@else
			@include('classified/layouts/inc/header')
		@endif
	@show

	@section('search')
	@show

	@if (isset($site_country_info))
		<div class="container" style="margin-bottom: -30px; margin-top: 20px;">
			<div class="row">
				<div class="col-lg-12">
					<div class="alert alert-warning">
						<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
						{!! $site_country_info !!}
					</div>
				</div>
			</div>
		</div>
	@endif

	@yield('content')

	@section('info')
	@show

	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				@section('footer')
					@include('classified/layouts/inc/footer')
				@show
			</div>
		</div>
	</div>

</div>

@section('modal-location')
@show
@section('modal-abuse')
@show
@section('modal-message')
@show

@section('javascript')
<!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.10.1/jquery.min.js"> </script> -->
<script src="/assets/js/jquery/1.10.1/jquery-1.10.1.js"></script>
<script src="/assets/bootstrap/js/bootstrap.min.js"></script>
<script src="/assets/plugins/retina/1.3.0/retina.js" type="text/javascript"></script>
<script src="/assets/js/jquery.matchHeight-min.js"></script>
<script src="/assets/plugins/jquery.fs.scroller/jquery.fs.scroller.min.js"></script>
<script src="/assets/plugins/select2/js/select2.full.min.js"></script>
<script src="/assets/plugins/SocialShare/SocialShare.min.js"></script>
<script src="/assets/js/owl.carousel.min.js"></script>
<script src="/assets/js/hideMaxListItem-min.js"></script>
<script language="javascript">
	var languageCode = '<?php echo $lang->get('abbr'); ?>';
	var langLayout = {
		'hideMaxListItems': {
			'moreText': "{{ t('View More') }}",
			'lessText': "{{ t('View Less') }}"
		}
	};
	$(document).ready(function () {
		/* Select Boxes */
		$(".selecter").select2({
			language: '<?php echo $lang->get('abbr'); ?>',
			dropdownAutoWidth: 'true',
			minimumResultsForSearch: Infinity
		});
		/* Searchable Select Boxes */
		$(".sselecter").select2({
			language: '<?php echo $lang->get('abbr'); ?>',
			dropdownAutoWidth: 'true',
		});

		/* Social Share */
		$('.share').ShareLink({
			title: '<?php echo addslashes(MetaTag::get('title')); ?>',
			text: '<?php echo addslashes(MetaTag::get('title')); ?>',
			url: '<?php echo \Illuminate\Support\Facades\URL::full(); ?>'
		});
	});
</script>
<script src="/assets/js/script.js?time={{ time() }}"></script>
<script type="text/javascript" src="/assets/plugins/autocomplete/jquery.mockjax.js"></script>
<script type="text/javascript" src="/assets/plugins/autocomplete/jquery.autocomplete.min.js"></script>
<script type="text/javascript" src="/assets/js/app/autocomplete.cities.js"></script>
@show

{!! config('settings.seo_google_analytics') !!}
</body>
</html>